package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 扫码记录分页dto
 * @author songjingen
 */
@Data
@ApiModel(value = "ScanCodeRecordPageDto", description = "扫码记录分页dto")
public class ScanCodeRecordPageDto {

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 商品唯一码集合（物料编码集合）
   */
  @ApiModelProperty("商品唯一码集合（物料编码集合）")
  private List<String> productCodes;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 扫码开始时间
   */
  @ApiModelProperty("扫码开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 扫码结束时间
   */
  @ApiModelProperty("扫码结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 扫码异常 0-无
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码异常 0-无")
  private String scanCodeException;


  @ApiModelProperty(value = "任务编码",hidden = true)
  private String businessCode;
}
