package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 扫码记录统计dto
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecordStatisticsDto", description = "扫码记录统计dto")
public class ScanCodeRecordStatisticsDto {
  private static final long serialVersionUID = -4803792689695774109L;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 扫码时间开始
   */
  @ApiModelProperty("扫码时间开始")
  private Date createTimeStart;

  /**
   * 扫码时间结束
   */
  @ApiModelProperty("扫码时间结束")
  private Date createTimeEnd;

  /**
   * 物料编码集合
   */
  @ApiModelProperty("物料编码集合")
  private List<String> materialCodes;
}
