package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;

/**
 * 扫码统计请求dto
 *
 * @author sunx
 * @date 2022/3/30
 */
@Data
@ApiModel(value = "ScanCodeReportDto", description = "扫码统计请求dto")
public class ScanCodeReportDto {

  /** 码流转参与者编码 */
  @ApiModelProperty("码流转参与者编码")
  private String barCodeParticipatorCode;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖,4-出库")
  private Set<String> scanTypeSet;

  /**
   * 扫码类型：查询类型：1-月度，2-季度，3-年度
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeReportSearchTypeEnum
   */
  @ApiModelProperty(
      "查询类型：1-月度，2-季度，3-年度 ;ALL(\"ALL\", \"0\", \"全部\", \"0\"),\n"
          + "  MONTH(\"month\", \"1\", \"月度\", \"1\"),\n"
          + "  SEASON(\"season\", \"2\", \"季度\", \"2\"),\n"
          + "  YEAR(\"year\", \"3\", \"年度\", \"3\"),\n"
          + "  TODAY(\"today\", \"4\", \"今日\", \"4\"),\n"
          + "  YESTERDAY(\"yesterday\", \"5\", \"昨日\", \"5\"),\n"
          + "  WEEK(\"week\", \"6\", \"本周\", \"6\"),")
  private Set<String> searchTypeSet;
}
