package com.biz.crm.cps.external.barcode.sdk.event;

import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeEventDto;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialStandardUnitVo;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialVo;

import java.util.List;

/**
 * 条码模块事件 上层模块实现此监听事件进行相应的逻辑处理
 *
 * @author songjingen
 */
public interface BarCodeMaterialStandardEventListener {

  /**
   * 通知上层模块相应的逻辑处理,并且返回对应的数据结构
   *
   * @param dtos
   * @return
   */
  List<BarCodeMaterialStandardUnitVo> onRequestMaterialStandardUnit(List<BarCodeEventDto> dtos);

  /**
   * 通知上层模块相应的逻辑处理,并且返回物料基本信息
   *
   * @param dto 请求参数
   * @return 物料基本信息
   */
  BarCodeMaterialVo onRequestMaterial(BarCodeEventDto dto);
}
