package com.biz.crm.cps.external.barcode.sdk.event;

import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;

/**
 * 消费者扫码时
 * barcode模块向上通知事件
 * @author songjingen
 */
public interface ConsumerScanCodeRecordEventListener {

  /**
   * 当扫码成功时，通知上层模块进行相对应的逻辑处理
   * @param dto
   * @return
   */
  void onSuccessScan(ScanCodeRecordEventDto dto);

  /**
   * 当扫码失败时，通知上层模块进行相对应的逻辑处理
   * @param dto
   */
  void onFailScan(ScanCodeRecordEventDto dto);
}
