package com.biz.crm.cps.external.barcode.sdk.event;

import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialVo;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * barcode模块向上校验事件
 *
 * @author songjingen
 */
public interface ScanCodeVerifyEventListener {

  /**
   * 扫码时，请求上层校验码是否存在已签署的协议
   *
   * @param scanCodeExceptionStrategyDto 扫码请求参数
   */
  default void checkBarcode(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {}

  /**
   * 终端扫码时，请求上层校验是否跨渠道扫码
   *
   * @param scanCodeExceptionStrategyDto 扫码请求参数
   */
  default void checkTerminalChannel(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {}

  /**
   * 终端/消费者扫码时，请求上层校验扫码位置
   *
   * @param scanCodeExceptionStrategyDto 扫码请求参数
   */
  default void checkScanLocation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto, BigDecimal locationMax) {}

  /**
   * 终端扫码时，请求上层校验是否非供货关系产品
   *
   * @param barCodeMaterialVo 扫码请求参数
   */
  default void checkTerminalSupply(BarCodeMaterialVo barCodeMaterialVo) {}

  /**
   * 终端扫码时，请求上层校验是否非供货关系经销商
   *
   * @param barCodeMaterialVo 扫码请求参数
   */
  default void checkTerminalSupplyDealer(ScanCodeExceptionStrategyDto dto,String dealerCode) {}

  /**
   * 扫码活动验证是否存在已参加且进行中的活动，并返回扫码活动编码，目前对应的实现在以下模块，协议活动无需实现该验证接口
   *
   * @see com.biz.crm.cps.business.activity.scan
   * @param scanCodeExceptionStrategyDto
   * @return
   */
  default String findActCodeByScanCodeExceptionStrategyDto(
      ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
    return StringUtils.EMPTY;
  }
}
