package com.biz.crm.cps.external.barcode.sdk.service;

import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeDto;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeVo;

import java.util.List;

/**
 * 条码voService
 * @author songjingen
 */
public interface BarCodeVoService {

  /**
   * 新增条码树数据集合
   * @param barCodeDtos
   * @return
   */
  List<BarCodeVo> create(List<BarCodeDto> barCodeDtos);

  /**
   * 新增条码数据
   * @param barCodeDto
   * @return
   */
  BarCodeVo create(BarCodeDto barCodeDto);

  /**
   * 根据条码集合查询集合
   * @param barCodes
   * @return
   */
  List<BarCodeVo> findByBarCodes(List<String> barCodes);

  /**
   * 根据条码查询对象信息
   * @param barCode
   * @return
   */
  BarCodeVo findByBarCode(String barCode);

  /**
   * 根据物料编码修改标瓶和标箱结果
   * @param productCodes
   */
  void updateByProductCodes(List<String> productCodes);

  /**
   * 根据条码集合查询集合
   * @param barCode
   * @return
   */
  List<BarCodeVo> findByParentBarCode(String barCode);
}
