package com.biz.crm.cps.external.barcode.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanBarCodeRecordFindDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.vo.KeyValueVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;

/**
 * 扫码记录voService
 *
 * @author songjingen
 */
public interface ScanCodeRecordVoService {

  /**
   * 新增扫码记录
   *
   * @param scanCodeRecordDto
   * @return
   */
  ScanCodeRecordVo create(ScanCodeRecordDto scanCodeRecordDto);

  /**
   * 扫码记录根据查询条件统计数量
   *
   * @param scanCodeRecordStatisticsDto
   * @return
   */
  Integer countByScanCodeRecordDto(ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto);

  /**
   * 查询扫码记录分页信息
   *
   * @param dto
   * @param pageable
   * @return
   */
  Page<ScanCodeRecordVo> findByConditions(ScanCodeRecordPageDto dto, Pageable pageable);

  /**
   * 统计扫码记录对应的销量
   *
   * @param dto
   * @return
   */
  BigDecimal countSalesByScanCodeRecordPageDto(ScanCodeRecordPageDto dto);

  /**
   * 根据参与者编码查询扫码成功集合
   *
   * @param scanParticipatorCode
   * @return
   */
  List<ScanCodeRecordVo> findByScanParticipatorCode(String scanParticipatorCode);

  /**
   * 扫码记录根据查询条件统计数量
   *
   * @param scanCodeRecords
   * @return
   */
  List<KeyValueVo> countByScanCodeRecordGroup(List<String> scanCodeRecords);

  /**
   * 根据码编码查询扫码（成功）记录
   *
   * @param barCode 码编码
   * @return 扫码记录
   */
  List<ScanCodeRecordVo> findByBarCode(String barCode);

  /**
   * 获取最近条码扫码业务员编码（经销商编码、终端编码）
   *
   * @param dto
   * @return
   */
  default String findLastScanUserCodeByScanBarCodeRecordFindDto(ScanBarCodeRecordFindDto dto) {
    return StringUtils.EMPTY;
  }

  /**
   * 根据扫码记录编码查询
   * @param recordCode
   * @return
   */
  ScanCodeRecordVo findByRecordCode(String recordCode);
}
