package com.biz.crm.cps.external.barcode.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 物料标箱信息Vo
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BarCodeMaterialStandardUnitVo", description = "物料标箱信息Vo")
public class BarCodeMaterialStandardUnitVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7755748861593003607L;

  /**
   * 条码
   */
  @ApiModelProperty("条码")
  private String barCode;

  /**
   * 条码
   */
  @ApiModelProperty("条码类型")
  private String barCodeType;
  /**
   * 商品唯一编码
   */
  @ApiModelProperty("商品唯一编码")
  private String productCode;
  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;
  /**
   * 标准单位转换结果 数值+描述
   */
  @ApiModelProperty("标准单位结果")
  private String standardUnit;
  /**
   * 标准单位转换结果 标箱数值
   */
  @ApiModelProperty("标准单位结果标箱数值")
  private BigDecimal standardUnitBoxValue;

  /**
   * 标准单位转换结果 标盒数值
   */
  @ApiModelProperty("标准单位结果标盒数值")
  private BigDecimal standardUnitBottleValue;
  /**
   * 标准单位
   */
  @ApiModelProperty("标准单位")
  private String standardUnitType;
  /**
   * 标准单位转换描述
   */
  @ApiModelProperty("标准单位转换描述")
  private List<String> standardUnitDesc;

}
