package com.biz.crm.cps.external.barcode.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 外部条形码对应物料实体类
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BarcodeMaterialVo", description = "外部条形码对应物料VO")
public class BarCodeMaterialVo  {
  private static final long serialVersionUID = 1650864227829818670L;

  /**
   * 商品唯一编码
   */
  @ApiModelProperty("商品唯一编码")
  private String productCode;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /**
   * 扫码对应终端编码
   */
  @ApiModelProperty("扫码对应终端编码")
  private String terminalCode;

}
