package com.biz.crm.cps.external.barcode.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 外部条形码实体类
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Barcode", description = "外部条形码实体类")
public class BarCodeVo extends TenantOpVo {
  private static final long serialVersionUID = 1650864227829818670L;

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 所属父级码
   */
  @ApiModelProperty("所属父级码")
  private String parentBarCode;

  /**
   * 拉平祖级结构（如：父级码1,父级码2,当前码）
   */
  @ApiModelProperty("拉平祖级结构（如：父级码1,父级码2,当前码）")
  private String flatAncestors;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   *
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 商品唯一编码
   */
  @ApiModelProperty("商品唯一编码")
  private String productCode;

  /**
   * 下属码
   */
  @ApiModelProperty("下属码")
  private List<BarCodeVo> childrenBarCode;

  /**
   * 标准单位转换结果 标箱数值
   */
  @ApiModelProperty("标准单位结果标箱数值")
  private BigDecimal standardUnitBoxValue;

  /**
   * 标准单位转换结果 标盒数值
   */
  @ApiModelProperty("标准单位结果标盒数值")
  private BigDecimal standardUnitBottleValue;

  /**
   * 条码（明码）
   */
  @ApiModelProperty("条码（明码）")
  private String barCodeWhite;

}
