package com.biz.crm.cps.external.barcode.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 扫码异常场景策略信息vo
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeExceptionStrategyVo", description = "扫码异常场景策略信息vo")
public class ScanCodeExceptionStrategyVo {

  /** 条码所属参与者编码 */
  @ApiModelProperty("条码所属参与者编码")
  private String barCodeParticipatorCode;

  /**
   * 协议扫码异常信息
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("协议扫码异常信息")
  private String scanCodeException;

  /** 活动扫码活动编码 */
  @ApiModelProperty("活动扫码活动编码")
  private String scanActCode;

  /** 备注 */
  @ApiModelProperty("备注")
  private String remark;

  /** 是否允许预警标记 */
  @ApiModelProperty("是否允许预警标记")
  private String allowConfig;
}
