package com.biz.crm.cps.external.barcode.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 扫码记录实体类
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecord", description = "扫码记录实体类")
public class ScanCodeRecordVo extends TenantOpVo {
  private static final long serialVersionUID = -4803792689695774109L;

  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 录入类型：1-手动，2-自动
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.EnterTypeEnum
   */
  @ApiModelProperty("录入类型：1-手动，2-自动")
  private String enterType;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 码流转参与者编码
   */
  @ApiModelProperty("码流转参与者编码")
  private String barCodeParticipatorCode;


  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private String longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private String latitude;

  /**
   * 拉平祖级结构（如：父级码1,父级码2,当前码）
   */
  @ApiModelProperty("拉平祖级结构（如：父级码1,父级码2,当前码）")
  private String flatAncestors;

  /**
   * 扫码异常：0-无，1-重复扫码，2-已扫过箱码，对应的盒码作废！，3-已扫过盒码，对应的箱码作废！
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;

  /**
   * 扫码预警
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码预警")
  private String scanCodeWarning;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 扫码记录对应物料编码
   */
  @ApiModelProperty("扫码对应物料编码")
  private String productCode;

  /**
   * 扫码记录对应物料名称
   */
  @ApiModelProperty("扫码对应物料名称")
  private String productName;

  /**
   * 标准单位转换结果
   */
  @ApiModelProperty("标准单位结果")
  private String standardUnit;
  /**
   * 标准单位转换描述
   */
  @ApiModelProperty("标准单位转换描述")
  private List<String> standardUnitDesc;

  /**
   * 标准单位转换结果 标箱数值
   */
  @ApiModelProperty("标准单位结果标箱数值")
  private BigDecimal standardUnitBoxValue;

  /**
   * 标准单位转换结果 标盒数值
   */
  @ApiModelProperty("标准单位结果标盒数值")
  private BigDecimal standardUnitBottleValue;

  /**
   * 标准单位转换结果 标盒数值
   */
  @ApiModelProperty("所属协议模板")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 所属协议模板
   */
  @ApiModelProperty("所属协议模板")
  private String templateName;

  /**
   * 经销商扫码出库关联终端编码
   */
  @ApiModelProperty("经销商扫码出库关联终端编码")
  private String terminalCode;

  /**
   * 经销商扫码出库关联渠道编码
   */
  @ApiModelProperty("经销商扫码出库关联渠道编码")
  private String channelCode;
}
