package com.biz.crm.cps.external.barcode.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码统计响应vo
 *
 * @author sunx
 * @date 2022/3/30
 */
@Data
@ApiModel(value = "ScanCodeReportVo", description = "扫码统计响应vo")
public class ScanCodeReportVo {

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖,4-出库")
  private String scanType;

  /**
   * 扫码类型：查询类型：1-月度，2-季度，3-年度
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeReportSearchTypeEnum
   */
  @ApiModelProperty(
      "查询类型：ALL(\"ALL\", \"0\", \"全部\", \"0\"),\n"
          + "  MONTH(\"month\", \"1\", \"月度\", \"1\"),\n"
          + "  SEASON(\"season\", \"2\", \"季度\", \"2\"),\n"
          + "  YEAR(\"year\", \"3\", \"年度\", \"3\"),\n"
          + "  TODAY(\"today\", \"4\", \"今日\", \"4\"),\n"
          + "  YESTERDAY(\"yesterday\", \"5\", \"昨日\", \"5\"),\n"
          + "  WEEK(\"week\", \"6\", \"本周\", \"6\"),")
  private String searchType;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty(
      "码类型:BOX(\"box\", \"1\", \"箱\"),\n"
          + "  BOTTLE(\"bottle\", \"2\", \"盒\"),\n"
          + "  COVER_CODE(\"coverCode\", \"3\", \"盖内码\");")
  private String barCodeType;

  /** 数量 */
  @ApiModelProperty("数量")
  private Integer quantity;
}
