/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.capital.tax.raise.local.service.observer;

import com.biz.crm.cps.business.capital.sdk.dto.CapitalRechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.CapitalRechargeInfoDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeConditionDto;
import com.biz.crm.cps.business.capital.sdk.service.observer.RechargeMountRegister;
import com.biz.crm.cps.business.capital.sdk.service.observer.RechargeServiceObserver;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeProcessVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.capital.tax.raise.local.config.CapitalTaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeAccountTypeEnum;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeContractSignStatus;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargePersonVerifyStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseRechargeVoService;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractTemplateVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractSignVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxRechargeServiceObserverImpl
implements RechargeServiceObserver {
    @Autowired
    @Qualifier(value="TaxRechargeMountRegisterImpl")
    private RechargeMountRegister rechargeMountRegister;
    @Autowired
    private TaxRaiseRechargeVoService taxRaiseRechargeVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TaxRaiseRechargeAccountVoService taxRaiseRechargeAccountVoService;
    @Autowired
    private TaxRaiseRechargeContractSignVoService taxRaiseRechargeContractSignVoService;
    @Autowired
    private TaxRaiseRechargeContractTemplateVoService taxRaiseRechargeContractTemplateVoService;
    @Autowired
    private CapitalTaxRaiseProperties capitalTaxRaiseProperties;

    public RechargeProcessVo onRequestRechargeProcess(RechargeConditionDto rechargeCondition) {
        if (Objects.isNull(rechargeCondition) || !Objects.equals(rechargeCondition.getRechargeKey(), this.rechargeMountRegister.getKey())) {
            return null;
        }
        RechargeProcessVo vo = new RechargeProcessVo();
        vo.setFlag(this.rechargeMountRegister.getFlag());
        vo.setKey(this.rechargeMountRegister.getKey());
        vo.setName(this.rechargeMountRegister.getName());
        MerchantAccountDto merchantAccountDto = new MerchantAccountDto();
        merchantAccountDto.setMerchantUserAccount(rechargeCondition.getMerchantUserAccount());
        TaxRaiseRechargeAccountVo accountVo = this.taxRaiseRechargeAccountVoService.findByMerchantAccountDto(merchantAccountDto);
        boolean needVerify = this.requiredAgainVerify(accountVo);
        vo.setNeedVerify(needVerify);
        if (!needVerify) {
            this.requiredContractSign(vo, rechargeCondition);
        } else {
            if (Objects.isNull(accountVo)) {
                accountVo = this.createVerifyUrl(rechargeCondition);
            }
            vo.setVerifyUrl(accountVo.getVerifyUrl());
            vo.setCertStatus(accountVo.getCertStatus());
            vo.setCompanyAuditFailReason(accountVo.getCompanyAuditFailReason());
            vo.setCompanyStatus(accountVo.getCompanyStatus());
            vo.setPersonAuditFailReason(accountVo.getPersonAuditFailReason());
            vo.setPersonStatus(accountVo.getPersonStatus());
            vo.setNeedSign(true);
        }
        return vo;
    }

    @Transactional
    public CapitalRechargeVo onRecharge(CapitalRechargeInfoDto capitalRechargeInfoDto) {
        Validate.notNull((Object)capitalRechargeInfoDto, (String)"\u5145\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRechargeInfoDto.getRechargeKey(), (String)"\u5145\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)capitalRechargeInfoDto.getCapitalRechargeDtos(), (String)"\u5145\u503c\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Objects.equals(capitalRechargeInfoDto.getRechargeKey(), this.rechargeMountRegister.getKey())) {
            List taxRaiseRechargeDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)capitalRechargeInfoDto.getCapitalRechargeDtos(), CapitalRechargeDto.class, TaxRaiseRechargeDto.class, HashSet.class, LinkedList.class, new String[0]);
            this.taxRaiseRechargeVoService.pushRechargeBatch(taxRaiseRechargeDtos);
        }
        return null;
    }

    private boolean requiredAgainVerify(TaxRaiseRechargeAccountVo accountVo) {
        if (Objects.isNull(accountVo)) {
            return true;
        }
        return !(Objects.equals(accountVo.getAccountType(), TaxRaiseRechargeAccountTypeEnum.PERSON.getDictCode()) && Objects.equals(accountVo.getPersonStatus(), TaxRaiseRechargePersonVerifyStatusEnum.PASSED.getDictCode()) || Objects.equals(accountVo.getAccountType(), TaxRaiseRechargeAccountTypeEnum.COMPANY.getDictCode()) && Objects.equals(accountVo.getCompanyStatus(), TaxRaiseRechargeCompanyVerifyStatusEnum.PASSED.getDictCode()));
    }

    private TaxRaiseRechargeAccountVo createVerifyUrl(RechargeConditionDto rechargeCondition) {
        TaxRaiseRechargeAccountDto dto = new TaxRaiseRechargeAccountDto();
        dto.setAccountType(TaxRaiseRechargeAccountTypeEnum.COMPANY.getDictCode());
        dto.setMerchantUserAccount(rechargeCondition.getMerchantUserAccount());
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(rechargeCondition.getParticipatorFlag())) {
            dto.setReturnUrl(this.capitalTaxRaiseProperties.getDealerRechargeReturnUrl());
        }
        this.taxRaiseRechargeAccountVoService.create(dto);
        return this.taxRaiseRechargeAccountVoService.findByMerchantAccountDto((MerchantAccountDto)dto);
    }

    private String findContractSignUrl(RechargeConditionDto rechargeCondition, TaxRaiseRechargeContractTemplateVo contractTemplateVo) {
        TaxRaiseRechargeContractSignDto dto = new TaxRaiseRechargeContractSignDto();
        dto.setMerchantUserAccount(rechargeCondition.getMerchantUserAccount());
        dto.setTemplateCode(contractTemplateVo.getTemplateCode());
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(rechargeCondition.getParticipatorFlag())) {
            dto.setReturnUrl(this.capitalTaxRaiseProperties.getDealerRechargeReturnUrl());
        }
        TaxRaiseRechargeContractSignVo contractSignVo = this.taxRaiseRechargeContractSignVoService.create(dto);
        return contractSignVo.getSignUrl();
    }

    private void requiredContractSign(RechargeProcessVo vo, RechargeConditionDto rechargeCondition) {
        MerchantAccountDto dto = new MerchantAccountDto();
        dto.setMerchantUserAccount(rechargeCondition.getMerchantUserAccount());
        TaxRaiseRechargeContractTemplateVo contractTemplateVo = this.taxRaiseRechargeContractTemplateVoService.findByMerchantAccountDto(dto);
        Validate.notNull((Object)contractTemplateVo, (String)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u6a21\u677f\uff01", (Object[])new Object[0]);
        TaxRaiseRechargeContractSignDto signDto = new TaxRaiseRechargeContractSignDto();
        signDto.setMerchantUserAccount(rechargeCondition.getMerchantUserAccount());
        signDto.setTemplateCode(contractTemplateVo.getTemplateCode());
        TaxRaiseRechargeContractSignVo contractSignVo = this.taxRaiseRechargeContractSignVoService.findByTaxRaiseRechargeContractSignDto(signDto);
        vo.setNeedSign(false);
        if (Objects.nonNull(contractSignVo)) {
            if (!TaxRaiseRechargeContractSignStatus.SIGN.getDictCode().equals(contractSignVo.getSignStatus())) {
                vo.setContractSignUrl(contractSignVo.getSignUrl());
                vo.setNeedSign(true);
            } else {
                vo.setContractViewUrl(contractSignVo.getViewUrl());
            }
        } else {
            String contractSignUrl = this.findContractSignUrl(rechargeCondition, contractTemplateVo);
            vo.setContractSignUrl(contractSignUrl);
            vo.setNeedSign(true);
        }
    }
}

