package com.biz.crm.cps.external.cash.tax.raise.local.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 提现税筹配置信息
 *
 * @author ning.zhang
 * @date 2022/3/18
 */
@Configuration
@ConfigurationProperties(prefix = "tax.raise")
@Setter
@Getter
public class CashTaxRaiseProperties {

  /**
   * 经销商提现认证/合同签署返回地址
   */
  private String dealerWithdrawalReturnUrl;

  /**
   * 终端提现认证/合同签署返回地址
   */
  private String terminalWithdrawalReturnUrl;

}
