package com.biz.crm.cps.external.cash.tax.raise.local.service.observer;

import com.biz.crm.cps.business.cash.sdk.register.CashPayRegister;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.cash.tax.raise.sdk.constant.CashTaxRaiseConstant;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 聚薪兑换打款注册器实现
 *
 * @author ning.zhang
 * @date 2022/3/28
 */
@Service
public class TaxRaiseCashPayRegisterImpl implements CashPayRegister {

  @Autowired
  private TaxRaiseWithdrawalAccountVoService taxRaiseWithdrawalAccountVoService;

  @Override
  public String getKey() {
    return CashTaxRaiseConstant.TAX_RAISE_KEY;
  }

  @Override
  public String getName() {
    return CashTaxRaiseConstant.TAX_RAISE_NAME;
  }

  @Override
  public Map<String, String> pay(List<CashRecordVo> cashRecords) {
    this.payValidation(cashRecords);
    Map<String, TaxRaiseWithdrawalAccountVo> accountMap = this.buildAccountMap(cashRecords);
    //TODO 聚薪管家对接
//    List<JuXinOrderDto> orderDtoList = cashRecords.stream().map(cashRecordVo -> {
//      FadadaAccount account = accountMap.get(String.format("%s-%s", cashRecordVo.getParticipatorType(), cashRecordVo.getPayeeCode()));
//      Validate.notNull(account, "用户[%s],找不到法大大账号信息");
//      JuXinOrderDto orderDto = new JuXinOrderDto();
//      orderDto.setIdCardNo(account.getIdCard());
//      orderDto.setMerchantTrxOrderNo(cashRecordVo.getCashCode());
//      orderDto.setName(account.getPersonName());
//      orderDto.setPhone(account.getMobile());
//      orderDto.setBankNo(account.getBankCardNo());
//      orderDto.setSettleAmount(cashRecordVo.getAmount());
//      return orderDto;
//    }).collect(Collectors.toList());
//    String batchNo = this.juXinService.sendOrder(orderDtoList);
//    return cashRecords.stream().collect(Collectors.toMap(CashRecordVo::getCashCode,t -> batchNo));
    return null;
  }

  /**
   * 兑付打款校验
   *
   * @param cashRecords 兑付记录
   */
  private void payValidation(List<CashRecordVo> cashRecords) {
    Validate.isTrue(!CollectionUtils.isEmpty(cashRecords), "缺失打款对象");
    cashRecords.forEach(cashRecordVo -> {
      Validate.notBlank(cashRecordVo.getCashCode(), "缺失兑付流水编码");
      Validate.notBlank(cashRecordVo.getParticipatorType(), "缺失客户类型");
      Validate.notBlank(cashRecordVo.getPayeeCode(), "缺失收款人编码");
      List<String> participatorTypeList = Arrays.stream(ParticipatorTypeEnum.values()).map(ParticipatorTypeEnum::getDictCode).collect(Collectors.toList());
      Validate.isTrue(!ParticipatorTypeEnum.CONSUMER.getDictCode().equals(cashRecordVo.getParticipatorType()), "不支持消费者打款!");
      Validate.isTrue(participatorTypeList.contains(cashRecordVo.getParticipatorType()), "不支持的客户类型!");
      Validate.notNull(cashRecordVo.getAmount(), "缺失兑付金额");
      Validate.isTrue(cashRecordVo.getAmount().compareTo(BigDecimal.ZERO) > 0, "兑付金额不能小于0");
    });
  }

  /**
   * 构建法大大账号映射信息(key:用户类型-用户账号,value:法大大账号信息)
   *
   * @param cashRecords 兑换信息
   * @return 法大大账号映射信息
   */
  private Map<String, TaxRaiseWithdrawalAccountVo> buildAccountMap(List<CashRecordVo> cashRecords) {
    Map<String, TaxRaiseWithdrawalAccountVo> resultMap = Maps.newHashMap();
    Map<String, List<String>> typeAccountMap = cashRecords.stream().collect(Collectors
        .groupingBy(CashRecordVo::getParticipatorType, Collectors.mapping(CashRecordVo::getPayeeCode, Collectors.toList())));
    typeAccountMap.forEach((userType, accountList) -> {
      MerchantAccountBatchDto dto = new MerchantAccountBatchDto();
      dto.setMerchantUserAccounts(accountList);
      List<TaxRaiseWithdrawalAccountVo> userAccounts = this.taxRaiseWithdrawalAccountVoService.findByMerchantAccountBatchDto(dto);
      if (CollectionUtils.isEmpty(userAccounts)) {
        return;
      }
      userAccounts.forEach(userAccount -> {
        resultMap.put(userAccount.getMerchantUserAccount(), userAccount);
      });
    });
    return resultMap;
  }
}
