/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.tax.raise.local.service.observer;

import com.biz.crm.cps.business.cash.sdk.register.CashPayRegister;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TaxRaiseCashPayRegisterImpl
implements CashPayRegister {
    @Autowired
    private TaxRaiseWithdrawalAccountVoService taxRaiseWithdrawalAccountVoService;

    public String getKey() {
        return "taxRaise";
    }

    public String getName() {
        return "\u7a0e\u7b79";
    }

    public Map<String, String> pay(List<CashRecordVo> cashRecords) {
        this.payValidation(cashRecords);
        Map<String, TaxRaiseWithdrawalAccountVo> accountMap = this.buildAccountMap(cashRecords);
        return null;
    }

    private void payValidation(List<CashRecordVo> cashRecords) {
        Validate.isTrue((!CollectionUtils.isEmpty(cashRecords) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6253\u6b3e\u5bf9\u8c61", (Object[])new Object[0]);
        cashRecords.forEach(cashRecordVo -> {
            Validate.notBlank((CharSequence)cashRecordVo.getCashCode(), (String)"\u7f3a\u5931\u5151\u4ed8\u6d41\u6c34\u7f16\u7801", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)cashRecordVo.getParticipatorType(), (String)"\u7f3a\u5931\u5ba2\u6237\u7c7b\u578b", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)cashRecordVo.getPayeeCode(), (String)"\u7f3a\u5931\u6536\u6b3e\u4eba\u7f16\u7801", (Object[])new Object[0]);
            List participatorTypeList = Arrays.stream(ParticipatorTypeEnum.values()).map(ParticipatorTypeEnum::getDictCode).collect(Collectors.toList());
            Validate.isTrue((!ParticipatorTypeEnum.CONSUMER.getDictCode().equals(cashRecordVo.getParticipatorType()) ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6d88\u8d39\u8005\u6253\u6b3e!", (Object[])new Object[0]);
            Validate.isTrue((boolean)participatorTypeList.contains(cashRecordVo.getParticipatorType()), (String)"\u4e0d\u652f\u6301\u7684\u5ba2\u6237\u7c7b\u578b!", (Object[])new Object[0]);
            Validate.notNull((Object)cashRecordVo.getAmount(), (String)"\u7f3a\u5931\u5151\u4ed8\u91d1\u989d", (Object[])new Object[0]);
            Validate.isTrue((cashRecordVo.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5151\u4ed8\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        });
    }

    private Map<String, TaxRaiseWithdrawalAccountVo> buildAccountMap(List<CashRecordVo> cashRecords) {
        HashMap resultMap = Maps.newHashMap();
        Map typeAccountMap = cashRecords.stream().collect(Collectors.groupingBy(CashRecordVo::getParticipatorType, Collectors.mapping(CashRecordVo::getPayeeCode, Collectors.toList())));
        typeAccountMap.forEach((userType, accountList) -> {
            MerchantAccountBatchDto dto = new MerchantAccountBatchDto();
            dto.setMerchantUserAccounts(accountList);
            List userAccounts = this.taxRaiseWithdrawalAccountVoService.findByMerchantAccountBatchDto(dto);
            if (CollectionUtils.isEmpty((Collection)userAccounts)) {
                return;
            }
            userAccounts.forEach(userAccount -> resultMap.put(userAccount.getMerchantUserAccount(), userAccount));
        });
        return resultMap;
    }
}

