/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.tax.raise.local.service.observer;

import com.biz.crm.cps.business.capital.sdk.common.enums.DataSourceEnum;
import com.biz.crm.cps.business.cash.sdk.common.enums.CashPushStatusEnum;
import com.biz.crm.cps.business.cash.sdk.common.enums.CashStatusEnum;
import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.cash.sdk.service.CashRecordVoService;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashMountRegister;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashServiceObserver;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.cash.tax.raise.local.config.CashTaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaisePaymentDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal.TaxRaiseWithdrawalAccountTypeEnum;
import com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal.TaxRaiseWithdrawalCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal.TaxRaiseWithdrawalContractSignStatus;
import com.biz.crm.cps.external.tax.raise.sdk.enums.withdrawal.TaxRaiseWithdrawalPersonVerifyStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaisePaymentVoService;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractTemplateVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractSignVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractTemplateVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxRaiseCashServiceObserverImpl
implements CashServiceObserver {
    @Autowired
    @Qualifier(value="TaxRaiseCashMountRegisterImpl")
    private CashMountRegister cashMountRegister;
    @Autowired
    private TaxRaiseWithdrawalAccountVoService taxRaiseWithdrawalAccountVoService;
    @Autowired(required=false)
    private CashRecordVoService cashRecordVoService;
    @Autowired
    private TaxRaiseWithdrawalContractTemplateVoService taxRaiseWithdrawalContractTemplateVoService;
    @Autowired
    private TaxRaiseWithdrawalContractSignVoService taxRaiseWithdrawalContractSignVoService;
    @Autowired
    private TaxRaisePaymentVoService taxRaisePaymentVoService;
    @Autowired
    private CashTaxRaiseProperties cashTaxRaiseProperties;

    public CashProcessVo onRequestCashProcess(CashConditionDto cashCondition) {
        if (Objects.isNull(cashCondition) || !Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            return null;
        }
        CashProcessVo vo = new CashProcessVo();
        vo.setFlag(this.cashMountRegister.getFlag());
        vo.setKey(this.cashMountRegister.getKey());
        vo.setName(this.cashMountRegister.getName());
        MerchantAccountDto merchantAccountDto = new MerchantAccountDto();
        merchantAccountDto.setMerchantUserAccount(cashCondition.getPayeeCode());
        TaxRaiseWithdrawalAccountVo accountVo = this.taxRaiseWithdrawalAccountVoService.findByMerchantAccountDto(merchantAccountDto);
        boolean needVerify = this.requiredAgainVerify(accountVo);
        vo.setNeedVerify(needVerify);
        if (!needVerify) {
            this.requiredContractSign(vo, cashCondition);
        } else {
            if (Objects.isNull(accountVo)) {
                accountVo = this.createVerifyUrl(cashCondition);
            }
            vo.setVerifyUrl(accountVo.getVerifyUrl());
            vo.setCertStatus(accountVo.getCertStatus());
            vo.setCompanyAuditFailReason(accountVo.getCompanyAuditFailReason());
            vo.setPersonAuditFailReason(accountVo.getPersonAuditFailReason());
            vo.setCompanyStatus(accountVo.getCompanyStatus());
            vo.setPersonStatus(accountVo.getPersonStatus());
            vo.setNeedSign(true);
        }
        return vo;
    }

    @Transactional
    public CashProcessVo onCreateContract(CashConditionDto cashCondition) {
        return null;
    }

    @Transactional
    public CashRecordVo onCash(CashConditionDto cashCondition) {
        Validate.notNull((Object)cashCondition, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)cashCondition.getAmount(), (String)"\u5151\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((cashCondition.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5151\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        if (Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            CashRecordDto cashRecordDto = new CashRecordDto();
            cashRecordDto.setAmount(cashCondition.getAmount());
            cashRecordDto.setParticipatorCode(cashCondition.getParticipatorCode());
            cashRecordDto.setParticipatorType(cashCondition.getParticipatorFlag());
            cashRecordDto.setParticipatorName(cashCondition.getParticipatorName());
            cashRecordDto.setCashMethodKey(this.cashMountRegister.getKey());
            cashRecordDto.setCashMethodName(this.cashMountRegister.getName());
            cashRecordDto.setCashStatus(CashStatusEnum.NO_PAID.getDictCode());
            cashRecordDto.setRewardKey(cashCondition.getRewardKey());
            cashRecordDto.setRewardName(cashCondition.getRewardName());
            cashRecordDto.setPayeePhone(cashCondition.getPayeePhone());
            cashRecordDto.setPayeeCode(cashCondition.getPayeeCode());
            cashRecordDto.setPayeeName(cashCondition.getPayeeName());
            cashRecordDto.setPushStatus(CashPushStatusEnum.PUSH_SUCCESS.getDictCode());
            cashRecordDto.setPushStatus(CashPushStatusEnum.PUSH_SUCCESS.getDictCode());
            CashRecordVo cashRecordVo = this.cashRecordVoService.create(cashRecordDto);
            this.pushPaymentBatch(cashRecordVo);
            return cashRecordVo;
        }
        return null;
    }

    private boolean requiredAgainVerify(TaxRaiseWithdrawalAccountVo accountVo) {
        if (Objects.isNull(accountVo)) {
            return true;
        }
        return !(Objects.equals(accountVo.getAccountType(), TaxRaiseWithdrawalAccountTypeEnum.PERSON.getDictCode()) && Objects.equals(accountVo.getPersonStatus(), TaxRaiseWithdrawalPersonVerifyStatusEnum.PASSED.getDictCode()) || Objects.equals(accountVo.getAccountType(), TaxRaiseWithdrawalAccountTypeEnum.COMPANY.getDictCode()) && Objects.equals(accountVo.getCompanyStatus(), TaxRaiseWithdrawalCompanyVerifyStatusEnum.PASSED.getDictCode()));
    }

    private TaxRaiseWithdrawalAccountVo createVerifyUrl(CashConditionDto cashCondition) {
        TaxRaiseWithdrawalAccountDto dto = new TaxRaiseWithdrawalAccountDto();
        dto.setAccountType(TaxRaiseWithdrawalAccountTypeEnum.PERSON.getDictCode());
        dto.setMerchantUserAccount(cashCondition.getPayeeCode());
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(cashCondition.getParticipatorFlag())) {
            dto.setReturnUrl(this.cashTaxRaiseProperties.getDealerWithdrawalReturnUrl());
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(cashCondition.getParticipatorFlag())) {
            dto.setReturnUrl(this.cashTaxRaiseProperties.getTerminalWithdrawalReturnUrl());
        }
        this.taxRaiseWithdrawalAccountVoService.create(dto);
        return this.taxRaiseWithdrawalAccountVoService.findByMerchantAccountDto((MerchantAccountDto)dto);
    }

    private String findContractSignUrl(CashConditionDto cashCondition, TaxRaiseWithdrawalContractTemplateVo contractTemplateVo) {
        TaxRaiseWithdrawalContractSignDto dto = new TaxRaiseWithdrawalContractSignDto();
        dto.setMerchantUserAccount(cashCondition.getPayeeCode());
        dto.setTemplateCode(contractTemplateVo.getTemplateCode());
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(cashCondition.getParticipatorFlag())) {
            dto.setReturnUrl(this.cashTaxRaiseProperties.getDealerWithdrawalReturnUrl());
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(cashCondition.getParticipatorFlag())) {
            dto.setReturnUrl(this.cashTaxRaiseProperties.getTerminalWithdrawalReturnUrl());
        }
        TaxRaiseWithdrawalContractSignVo contractSignVo = this.taxRaiseWithdrawalContractSignVoService.create(dto);
        return contractSignVo.getSignUrl();
    }

    private void requiredContractSign(CashProcessVo vo, CashConditionDto cashCondition) {
        MerchantAccountDto dto = new MerchantAccountDto();
        dto.setMerchantUserAccount(cashCondition.getPayeeCode());
        TaxRaiseWithdrawalContractTemplateVo contractTemplateVo = this.taxRaiseWithdrawalContractTemplateVoService.findByMerchantAccountDto(dto);
        Validate.notNull((Object)contractTemplateVo, (String)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u6a21\u677f\uff01", (Object[])new Object[0]);
        TaxRaiseWithdrawalContractSignDto signDto = new TaxRaiseWithdrawalContractSignDto();
        signDto.setMerchantUserAccount(cashCondition.getPayeeCode());
        signDto.setTemplateCode(contractTemplateVo.getTemplateCode());
        TaxRaiseWithdrawalContractSignVo contractSignVo = this.taxRaiseWithdrawalContractSignVoService.findByTaxRaiseWithdrawalContractSignDto(signDto);
        vo.setNeedSign(false);
        if (Objects.nonNull(contractSignVo)) {
            if (!TaxRaiseWithdrawalContractSignStatus.SIGN.getDictCode().equals(contractSignVo.getSignStatus())) {
                vo.setContractSignUrl(contractSignVo.getSignUrl());
                vo.setNeedSign(true);
            } else {
                vo.setContractViewUrl(contractSignVo.getViewUrl());
            }
        } else {
            String contractSignUrl = this.findContractSignUrl(cashCondition, contractTemplateVo);
            vo.setContractSignUrl(contractSignUrl);
            vo.setNeedSign(true);
        }
    }

    private void pushPaymentBatch(CashRecordVo cashRecordVo) {
        TaxRaisePaymentDto taxRaisePaymentDto = new TaxRaisePaymentDto();
        taxRaisePaymentDto.setCashCode(cashRecordVo.getCashCode());
        taxRaisePaymentDto.setRemark(cashRecordVo.getRemark());
        taxRaisePaymentDto.setCustomerCode(cashRecordVo.getPayeeCode());
        taxRaisePaymentDto.setCustomerName(cashRecordVo.getPayeeName());
        taxRaisePaymentDto.setPaymentAmount(cashRecordVo.getAmount());
        taxRaisePaymentDto.setAccountCode(cashRecordVo.getPayeeCode());
        taxRaisePaymentDto.setPaymentTime(cashRecordVo.getPayDate());
        taxRaisePaymentDto.setDataSource(DataSourceEnum.CPS_PUSH.getDictCode());
        ArrayList taxRaisePaymentDtos = Lists.newArrayList();
        taxRaisePaymentDtos.add(taxRaisePaymentDto);
        this.taxRaisePaymentVoService.pushPaymentBatch((List)taxRaisePaymentDtos);
    }
}

