package com.biz.crm.cps.external.cash.weixinpay.local.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author hecheng
 * @description: 微信支付配置
 */
@ConfigurationProperties(prefix = "wx.pay")
@Setter
@Getter
public class WXPayProperties {

  /**
   * App ID
   */
  private String appID;
  /**
   * Mch ID
   */
  private String mchID;
  /**
   * API 密钥
   */
  private String key;
  /**
   * 获取商户证书内容
   */
  private String certPath;
  /**
   * 跳过支付(作为测试时使用，为true时会跳过支付，直接扣钱 但不发钱)
   */
  private boolean skipPay = false;
}
