package com.biz.crm.cps.external.cash.weixinpay.local.config;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.external.cash.weixinpay.local.service.internal.WXPayConfigServiceImpl;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.IWXPayDomain;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPayConfig;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPayDomainSimpleImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * @author hecheng
 * @description: 微信支付配置
 * @date 2021/9/4 下午1:44
 */
@Component
@Slf4j
public class WeiXinPayConfig {
  @Autowired
  private WXPayProperties wxPayProperties;

  @Bean("wxPayConfig")
  public WXPayConfig getWXPayConfig(){
    IWXPayDomain wxPayDomain = WXPayDomainSimpleImpl.instance();
    WXPayConfigServiceImpl wxPayConfigService = new WXPayConfigServiceImpl(this.wxPayProperties,wxPayDomain);
    return wxPayConfigService;
  }
}
