package com.biz.crm.cps.external.cash.weixinpay.local.service.internal;

import com.biz.crm.cps.external.cash.weixinpay.local.config.WXPayProperties;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.IWXPayDomain;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPayConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import lombok.extern.slf4j.Slf4j;


/**
 * @author hecheng
 * @description: 微信支付配置
 * @date 2021/9/4 上午10:55
 */
@Slf4j
public class WXPayConfigServiceImpl extends WXPayConfig {


  /**
   *
   */
  private WXPayProperties wxPayProperties;
  /**
   *
   */
  private IWXPayDomain wxPayDomain;

  public WXPayConfigServiceImpl(WXPayProperties wxPayProperties,IWXPayDomain wxPayDomain) {
    this.wxPayProperties = wxPayProperties;
    this.wxPayDomain = wxPayDomain;
  }



  @Override
  public String getAppID() {
    return wxPayProperties.getAppID();
  }

  @Override
  public String getMchID() {
    return wxPayProperties.getMchID();
  }

  @Override
  public String getKey() {
    return wxPayProperties.getKey();
  }

  @Override
  public InputStream getCertStream() {
    File file = new File(wxPayProperties.getCertPath());
    byte[] certData = null;
    try (InputStream certStream = new FileInputStream(file)) {
      certData = new byte[(int) file.length()];
      certStream.read(certData);
    } catch (FileNotFoundException e) {
      log.error("获取商户证书内容失败"+e.getMessage(),e);
    } catch (IOException e) {
      log.error("获取商户证书内容失败"+e.getMessage(),e);
    }
    ByteArrayInputStream certBis;
    certBis = new ByteArrayInputStream(certData);
    return certBis;
  }

  @Override
  public IWXPayDomain getWXPayDomain() {
    return this.wxPayDomain;
  }
}
