/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.feign.config;

import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jaxb.JAXBContextFactory;
import feign.soap.SOAPDecoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class FeignClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FeignClientConfiguration.class);
    @Value(value="${webservice.myAuthKey:}")
    private String authKey = "";
    private Charset charsetEncoding = StandardCharsets.UTF_8;
    private String soapProtocol = "SOAP 1.1 Protocol";
    private static final JAXBContextFactory jaxbContextFactory = new JAXBContextFactory.Builder().withMarshallerJAXBEncoding("UTF-8").build();

    public abstract Encoder feignEncoder();

    public Encoder feignEncoder(String prefix, String namespace) {
        return (object, bodyType, template) -> {
            if (!(bodyType instanceof Class)) {
                throw new UnsupportedOperationException("SOAP only supports encoding raw types. Found " + bodyType);
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Marshaller marshaller = jaxbContextFactory.createMarshaller((Class)bodyType);
                marshaller.marshal(object, (Node)document);
                SOAPMessage soapMessage = MessageFactory.newInstance((String)this.soapProtocol).createMessage();
                SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                soapEnvelope.addNamespaceDeclaration(prefix, namespace);
                soapMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charsetEncoding.displayName());
                soapMessage.getSOAPBody().addDocument(document);
                soapMessage.writeTo((OutputStream)bos);
                template.body(new String(bos.toByteArray()).replaceAll("MT_COMMON", prefix.concat(":MT_COMMON")));
            }
            catch (Exception e) {
                log.error("\u62e6\u622a\u51fa\u9519", (Throwable)e);
            }
        };
    }

    @Bean
    public Decoder feignDecoder() {
        return new SOAPDecoder(jaxbContextFactory);
    }
}

