/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.feign.config;

import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.DigestUtils;

public class CovFeignClientConfiguration
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CovFeignClientConfiguration.class);
    @Value(value="${tianjian.appid:}")
    private String appid;
    @Value(value="${tianjian.appsecret:}")
    private String appsecret;

    public void apply(RequestTemplate requestTemplate) {
        requestTemplate.header("appid", new String[]{this.appid});
        String currentTime = String.valueOf(System.currentTimeMillis());
        requestTemplate.header("appRequestTime", new String[]{String.valueOf(currentTime)});
        Request.Body body = requestTemplate.requestBody();
        String s = body.asString();
        String data = StringUtils.trimToEmpty((String)s).concat(this.appid).concat(this.appsecret).concat(currentTime);
        requestTemplate.header("appSign", new String[]{DigestUtils.md5DigestAsHex((byte[])data.getBytes())});
    }
}

