/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.cps.external.mdm.sdk.service.DealerMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerCommunicationMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerContactPersonMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerMdmVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerDockingVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TDealerMdmServiceExpandImpl"})
public class DealerMdmServiceImpl
implements DealerMdmService {
    @Resource
    private CustomerVoService customerVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<DealerMdmVo> findByCustomerCodes(Collection<String> subtract) {
        if (CollectionUtils.isEmpty(subtract)) {
            return null;
        }
        List list = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList(subtract));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        LinkedList dealerMdmVos = Lists.newLinkedList();
        for (CustomerVo customerVo : list) {
            List orgList;
            List mdmCustomerDockingVos;
            DealerMdmVo dealerMdmVo = (DealerMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerVo, DealerMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
            dealerMdmVo.setChannelCode(customerVo.getChannel());
            dealerMdmVo.setLegalRepresent(customerVo.getLegalRepresentative());
            List mdmCustomerContactVos = customerVo.getContactList();
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerContactVos)) {
                HashSet dealerContactPersons = Sets.newHashSet();
                for (CustomerContactVo mdmCustomerContactVo : mdmCustomerContactVos) {
                    DealerContactPersonMdmVo dealerContactPersonMdmVo = new DealerContactPersonMdmVo();
                    dealerContactPersonMdmVo.setContactPersonName(mdmCustomerContactVo.getContactName());
                    dealerContactPersonMdmVo.setContactPersonPhone(mdmCustomerContactVo.getContactPhone());
                    dealerContactPersonMdmVo.setDealerId(customerVo.getId());
                    dealerContactPersons.add(dealerContactPersonMdmVo);
                }
                dealerMdmVo.setDealerContactPersons((Set)dealerContactPersons);
            }
            if (!CollectionUtils.isEmpty((Collection)(mdmCustomerDockingVos = customerVo.getDockingList()))) {
                HashSet dealerCommunicationMdmVos = Sets.newHashSet();
                for (CustomerDockingVo mdmCustomerDockingVo : mdmCustomerDockingVos) {
                    DealerCommunicationMdmVo dealerCommunicationMdmVo = new DealerCommunicationMdmVo();
                    dealerCommunicationMdmVo.setPositionCode(mdmCustomerDockingVo.getPositionCode());
                    dealerCommunicationMdmVo.setPositionName(mdmCustomerDockingVo.getPositionName());
                    dealerCommunicationMdmVo.setUserCode(mdmCustomerDockingVo.getUserName());
                    dealerCommunicationMdmVo.setUserName(mdmCustomerDockingVo.getFullName());
                    dealerCommunicationMdmVo.setCommunicationOrgCode(mdmCustomerDockingVo.getOrgCode());
                    dealerCommunicationMdmVo.setCommunicationOrgName(mdmCustomerDockingVo.getOrgName());
                    dealerCommunicationMdmVo.setCommunicationContact(mdmCustomerDockingVo.getContact());
                    dealerCommunicationMdmVo.setDealerId(customerVo.getId());
                    dealerCommunicationMdmVos.add(dealerCommunicationMdmVo);
                }
                dealerMdmVo.setDealerCommunications((Set)dealerCommunicationMdmVos);
            }
            if (!CollectionUtils.isEmpty((Collection)(orgList = customerVo.getOrgList()))) {
                dealerMdmVo.setOrgCode(orgList.stream().map(CustomerRelateOrgVo::getOrgCode).collect(Collectors.joining(",")));
                dealerMdmVo.setOrgName(orgList.stream().map(CustomerRelateOrgVo::getOrgName).collect(Collectors.joining(",")));
            }
            dealerMdmVos.add(dealerMdmVo);
        }
        return dealerMdmVos;
    }
}

