/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.cps.external.mdm.sdk.service.DictMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.DictTypeVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DictMdmServiceImpl
implements DictMdmService {
    public final String PATH_SPLIT = "/";
    @Autowired
    private DictDataVoService dictDataVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<DictTypeVo> findByTypeCodes(List<String> dictTypeCodes) {
        if (CollectionUtils.isEmpty(dictTypeCodes)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(dictTypeCodes)) {
            for (String dictTypeCode : dictTypeCodes) {
                DictTypeVo dictTypeVo = new DictTypeVo();
                dictTypeVo.setDictTypeCode(dictTypeCode);
                dictTypeVo.setDictVos(this.findByTypeCode(dictTypeCode));
                list.add(dictTypeVo);
            }
        }
        return list;
    }

    public List<DictVo> findByTypeCode(String dictTypeCode) {
        List<DictDataVo> list;
        if (!StringUtils.isEmpty((CharSequence)dictTypeCode) && !CollectionUtils.isEmpty(list = this.findDictDataByPath(dictTypeCode))) {
            Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, DictDataVo.class, DictVo.class, HashSet.class, ArrayList.class, new String[0]);
            return dictVos.stream().sorted(Comparator.comparing(DictVo::getDictSort)).collect(Collectors.toList());
        }
        return null;
    }

    private List<DictDataVo> findDictDataByPath(String path) {
        ArrayList list = Lists.newArrayList();
        if (!StringUtils.isEmpty((CharSequence)path)) {
            List<DictDataVo> dataVoList = this.findDictGroupByTypeCode(path);
            if (CollectionUtils.isEmpty(dataVoList)) {
                return list;
            }
            for (DictDataVo item : dataVoList) {
                String path2 = path + "/";
                if (!item.getPath().startsWith(path2)) continue;
                DictDataVo copy = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
                list.add(copy);
            }
        }
        return list;
    }

    private List<DictDataVo> findDictGroupByTypeCode(String dictTypeCode) {
        if (!StringUtils.isEmpty((CharSequence)dictTypeCode)) {
            Map resultMap = this.dictDataVoService.findByDictTypeCodeList(Collections.singletonList(dictTypeCode));
            if (resultMap == null || resultMap.isEmpty()) {
                return null;
            }
            return (List)resultMap.get(dictTypeCode);
        }
        return null;
    }
}

