/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.MaterialMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialGroupMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMediaMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductLevelMdmVo;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialMediaVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MaterialMdmServiceExpandImpl"})
public class MaterialMdmServiceImpl
implements MaterialMdmService {
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<MaterialMdmVo> findByConditions(Pageable pageable, MaterialMdmPaginationDto materialMdmPaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        MaterialPageDto materialPageDto = (MaterialPageDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialMdmPaginationDto, MaterialPageDto.class, HashSet.class, ArrayList.class, new String[0]);
        materialPageDto.setModifyEndDate(materialMdmPaginationDto.getEndDate());
        materialPageDto.setModifyStartDate(materialMdmPaginationDto.getStartDate());
        materialPageDto.setProductLevelCodes(materialMdmPaginationDto.getProductLevelCodes());
        materialPageDto.setMaterialCodes(materialMdmPaginationDto.getMaterialCodes());
        Page result = this.materialVoService.findByMaterialPageDto(pageable, materialPageDto);
        Page page = new Page();
        if (result != null) {
            List materialRespVos = result.getRecords().stream().map(item -> {
                MaterialMdmVo vo = (MaterialMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(item, MaterialMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                List mdmLevelMdmVos = item.getProductLevels();
                if (!CollectionUtils.isEmpty((Collection)mdmLevelMdmVos)) {
                    List levelMdmVos = mdmLevelMdmVos.stream().map(productLevelVo -> {
                        ProductLevelMdmVo mdmVo = new ProductLevelMdmVo();
                        BeanUtils.copyProperties((Object)productLevelVo, (Object)mdmVo, (String[])new String[]{"productLevelType"});
                        mdmVo.setProductLevelType(productLevelVo.getProductLevelType() != null ? productLevelVo.getProductLevelType().getCode() : null);
                        return mdmVo;
                    }).collect(Collectors.toList());
                    vo.setProductLevels(levelMdmVos);
                } else {
                    vo.setProductLevels((List)Lists.newArrayList());
                }
                List picList = item.getPicList();
                if (!CollectionUtils.isEmpty((Collection)picList)) {
                    List mediaMdmVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)picList, MaterialMediaVo.class, MaterialMediaMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                    vo.setMaterialMedias(mediaMdmVos);
                } else {
                    vo.setMaterialMedias((List)Lists.newArrayList());
                }
                return vo;
            }).collect(Collectors.toList());
            page.setTotal(result.getTotal());
            page.setCurrent(result.getCurrent());
            page.setSize(result.getSize());
            page.setRecords(materialRespVos);
        } else {
            page.setRecords((List)Lists.newArrayList());
        }
        return page;
    }

    public Page<MaterialGroupMdmVo> findByConditions(Pageable pageable, MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        materialGroupMdmPaginationDto.setPageNum(Integer.valueOf(pageable.getPageNumber()));
        materialGroupMdmPaginationDto.setPageSize(Integer.valueOf(pageable.getPageSize()));
        return new Page();
    }
}

