/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.event.TerminalMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaCustomerOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mdm.business.terminal.user.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserRelaTerminalVo;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TerminalMdnServiceExpandImpl"})
public class TerminalMdnServiceImpl
implements TerminalMdmService,
CopyObjectCallback<TerminalVo, TerminalMdmVo> {
    private static final Logger log = LoggerFactory.getLogger(TerminalMdnServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<TerminalMdmEventListener> terminalMdmEventListeners;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private TerminalUserVoService terminalUserVoService;
    @Autowired
    private LoginUserService loginUserService;

    public Page<TerminalMdmVo> findByConditions(Pageable pageable, TerminalMdmPaginationDto terminalMdmPaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (terminalMdmPaginationDto == null) {
            terminalMdmPaginationDto = new TerminalMdmPaginationDto();
        }
        if (!CollectionUtils.isEmpty(this.terminalMdmEventListeners)) {
            LinkedList list = Lists.newLinkedList();
            for (TerminalMdmEventListener listener : this.terminalMdmEventListeners) {
                List codes = listener.onFind();
                list.addAll(codes);
            }
            terminalMdmPaginationDto.setNotIncludeTerminalCodeList((List)list);
        }
        TerminalPaginationDto dto = new TerminalPaginationDto();
        dto.setTerminalCode(terminalMdmPaginationDto.getTerminalCode());
        dto.setTerminalName(terminalMdmPaginationDto.getTerminalName());
        dto.setOrgCode(terminalMdmPaginationDto.getOrganization());
        dto.setChannel(terminalMdmPaginationDto.getChannel());
        dto.setTerminalType(terminalMdmPaginationDto.getTerminalType());
        dto.setTagName(terminalMdmPaginationDto.getTerminalLabel());
        dto.setNotIncludeTerminalCodeList(terminalMdmPaginationDto.getNotIncludeTerminalCodeList());
        Page result = this.terminalVoService.findByTerminalPaginationDto(pageable, dto);
        if (Objects.isNull(result)) {
            return null;
        }
        List terminalMdmVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result.getRecords(), TerminalVo.class, TerminalMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
        Page page = new Page();
        page.setTotal(result.getTotal());
        page.setCurrent(result.getCurrent());
        page.setSize(result.getSize());
        page.setRecords(terminalMdmVos);
        return page;
    }

    public List<TerminalMdmVo> findByConditions(TerminalMdmPaginationDto terminalMdmPaginationDto) {
        if (terminalMdmPaginationDto == null) {
            terminalMdmPaginationDto = new TerminalMdmPaginationDto();
        }
        TerminalPaginationDto dto = new TerminalPaginationDto();
        dto.setTerminalCode(terminalMdmPaginationDto.getTerminalCode());
        dto.setTerminalName(terminalMdmPaginationDto.getTerminalName());
        dto.setOrgCode(terminalMdmPaginationDto.getOrganization());
        dto.setChannel(terminalMdmPaginationDto.getChannel());
        Page result = this.terminalVoService.findByTerminalPaginationDto((Pageable)PageRequest.of((int)0, (int)50), dto);
        if (Objects.nonNull(result) && !CollectionUtils.isEmpty((Collection)result.getRecords())) {
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result.getRecords(), TerminalVo.class, TerminalMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return Lists.newLinkedList();
    }

    public TerminalMdmVo findDetailByRegisterOrName(TerminalMdmPaginationDto terminalMdmPaginationDto) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{terminalMdmPaginationDto.getLicenseRegisterNumber(), terminalMdmPaginationDto.getTerminalAddress(), terminalMdmPaginationDto.getTerminalName()})) {
            return null;
        }
        TerminalPaginationDto registerDto = new TerminalPaginationDto();
        registerDto.setLicenseRegisterNumber(terminalMdmPaginationDto.getLicenseRegisterNumber());
        Page result = this.terminalVoService.findByTerminalPaginationDto((Pageable)PageRequest.of((int)0, (int)50), registerDto);
        if (Objects.nonNull(result) && !CollectionUtils.isEmpty((Collection)result.getRecords())) {
            return (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(result.getRecords().get(0), TerminalMdmVo.class, Set.class, ArrayList.class, new String[0]);
        }
        TerminalPaginationDto addressDto = new TerminalPaginationDto();
        addressDto.setTerminalName(terminalMdmPaginationDto.getTerminalName());
        addressDto.setTerminalAddress(terminalMdmPaginationDto.getTerminalAddress());
        result = this.terminalVoService.findByTerminalPaginationDto((Pageable)PageRequest.of((int)0, (int)50), addressDto);
        if (Objects.nonNull(result) && !CollectionUtils.isEmpty((Collection)result.getRecords())) {
            return (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(result.getRecords().get(0), TerminalMdmVo.class, Set.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    public TerminalMdmVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new TerminalMdmVo();
        }
        List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes((List)Lists.newArrayList((Object[])new String[]{id}), null);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(list.get(0), TerminalMdmVo.class, Set.class, ArrayList.class, new String[0]);
        }
        return new TerminalMdmVo();
    }

    @Transactional
    public void save(TerminalMdmVo terminalMdmVo) {
        Validate.notNull((Object)terminalMdmVo, (String)"\u4fdd\u5b58\u7ec8\u7aef\u4fe1\u606f\u5230mdm\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalMdmVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalDto dto = (TerminalDto)this.nebulaToolkitService.copyObjectByBlankList((Object)terminalMdmVo, TerminalDto.class, HashSet.class, ArrayList.class, new String[0]);
        dto.setFromType("cps");
        log.info("\u63a8\u9001mdm\u7ec8\u7aef\u6570\u636e={}", (Object)JSON.toJSONString((Object)dto));
        this.terminalVoService.create(dto);
    }

    public List<TerminalMdmVo> findDetailByCodes(Set<String> codes) {
        List resultList = this.terminalVoService.findMainDetailsByTerminalCodes((List)Lists.newArrayList(codes));
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)resultList, TerminalVo.class, TerminalMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
        }
        return Lists.newLinkedList();
    }

    public List<TerminalMdmVo> findByPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return Lists.newLinkedList();
        }
        TerminalUserVo terminalUserVo = this.terminalUserVoService.findByUserPhone(phone);
        if (Objects.isNull(terminalUserVo) || CollectionUtils.isEmpty((Collection)terminalUserVo.getTerminalList())) {
            return Lists.newLinkedList();
        }
        List terminalCodes = terminalUserVo.getTerminalList().stream().map(TerminalUserRelaTerminalVo::getTerminalCode).collect(Collectors.toList());
        List resultList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, terminalCodes);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)resultList, TerminalVo.class, TerminalMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
        return TerminalVo.class.isAssignableFrom(sourceClass) && TerminalMdmVo.class.isAssignableFrom(targetClass);
    }

    public void callback(Class<TerminalVo> sourceClass, List<TerminalVo> sourceObjects, Class<TerminalMdmVo> targetClass, List<TerminalMdmVo> targetObjects) {
        for (int i = 0; i < sourceObjects.size(); ++i) {
            TerminalVo sourceObject = sourceObjects.get(i);
            TerminalMdmVo targetObject = targetObjects.get(i);
            if (!CollectionUtils.isEmpty((Collection)sourceObject.getOrgList())) {
                targetObject.setOrgCode(String.join((CharSequence)",", sourceObject.getOrgList().stream().map(TerminalRelaOrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toList())));
                targetObject.setOrgName(String.join((CharSequence)",", sourceObject.getOrgList().stream().map(TerminalRelaOrgVo::getOrgName).filter(Objects::nonNull).collect(Collectors.toList())));
            }
            if (CollectionUtils.isEmpty((Collection)sourceObject.getCustomerOrgList())) continue;
            targetObject.setCustomerOrgCode(String.join((CharSequence)",", sourceObject.getCustomerOrgList().stream().map(TerminalRelaCustomerOrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toList())));
            targetObject.setCustomerOrgName(String.join((CharSequence)",", sourceObject.getCustomerOrgList().stream().map(TerminalRelaCustomerOrgVo::getOrgName).filter(Objects::nonNull).collect(Collectors.toList())));
        }
    }

    public void handleChangeTerminal(String terminalCode) {
        LoginUserDetailsForCPS loginDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginDetails, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u4fe1\u606f\uff0c\u8bf7\u767b\u5f55\uff01", (Object[])new Object[0]);
        List detailsByIdsOrUserCodes = this.terminalUserVoService.findDetailsByIdsOrUserCodes(null, (List)Lists.newArrayList((Object[])new String[]{loginDetails.getAccount()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)detailsByIdsOrUserCodes) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u767b\u5f55\uff01", (Object[])new Object[0]);
        TerminalUserVo terminalUserVo = detailsByIdsOrUserCodes.stream().findFirst().orElse(null);
        List terminalList = terminalUserVo.getTerminalList();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)terminalList) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u7528\u6237\u5173\u8054\u7684\u7ec8\u7aef\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TerminalUserRelaTerminalVo terminalUserRelaTerminalVo = terminalList.stream().filter(a -> a.getTerminalCode().equals(terminalCode)).findFirst().orElse(null);
        Validate.notNull((Object)terminalUserRelaTerminalVo, (String)"\u672a\u67e5\u8be2\u5230\u767b\u5f55\u7528\u6237\u5173\u8054\u7684\u7ec8\u7aef\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SecurityContext context = SecurityContextHolder.getContext();
        loginDetails.setConsumerCode(terminalUserRelaTerminalVo.getTerminalCode());
        loginDetails.setConsumerName(terminalUserRelaTerminalVo.getTerminalName());
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)loginDetails.getAccount(), (Object)loginDetails.getPassword(), context.getAuthentication().getAuthorities());
        authentication.setDetails((Object)loginDetails);
        context.setAuthentication((Authentication)authentication);
    }
}

