/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.event.TerminalMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.service.ParticipatorTagMdmService;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.ParticipatorTagMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalContactMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TerminalMdnServiceExpandImpl"})
public class TerminalMdnServiceImpl
implements TerminalMdmService {
    private static final Logger log = LoggerFactory.getLogger(TerminalMdnServiceImpl.class);
    @Autowired(required=false)
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private ParticipatorTagMdmService participatorTagMdmService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<TerminalMdmEventListener> terminalMdmEventListeners;

    public Page<TerminalMdmVo> findByConditions(Pageable pageable, TerminalMdmPaginationDto terminalMdmPaginationDto) {
        Collection<Object> codes;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (terminalMdmPaginationDto == null) {
            terminalMdmPaginationDto = new TerminalMdmPaginationDto();
        }
        if (!CollectionUtils.isEmpty(this.terminalMdmEventListeners)) {
            LinkedList list = Lists.newLinkedList();
            for (TerminalMdmEventListener listener : this.terminalMdmEventListeners) {
                codes = listener.onFind();
                list.addAll(codes);
            }
            terminalMdmPaginationDto.setNotIncludeTerminalCodeList((List)list);
        }
        MdmTerminalVo reqVo = new MdmTerminalVo();
        reqVo.setTerminalCode(terminalMdmPaginationDto.getTerminalCode());
        reqVo.setTerminalName(terminalMdmPaginationDto.getTerminalName());
        reqVo.setOrgCode(terminalMdmPaginationDto.getOrganization());
        reqVo.setChannel(terminalMdmPaginationDto.getChannel());
        reqVo.setPageSize(Integer.valueOf(pageable.getPageSize()));
        reqVo.setPageNum(Integer.valueOf(pageable.getPageNumber()));
        reqVo.setTerminalType(terminalMdmPaginationDto.getTerminalType());
        reqVo.setTagName(terminalMdmPaginationDto.getTerminalLabel());
        reqVo.setNotIncludeTerminalCodeList(terminalMdmPaginationDto.getNotIncludeTerminalCodeList());
        Result result = this.mdmTerminalFeign.page(reqVo);
        if (!result.isSuccess()) {
            return null;
        }
        ArrayList terminalMdmVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)((PageResult)result.getResult()).getData(), MdmTerminalVo.class, TerminalMdmVo.class, HashSet.class, ArrayList.class, new String[]{"contacts", "supplys", "channelList", "orgList"}));
        codes = terminalMdmVos.stream().map(TerminalMdmVo::getTerminalCode).collect(Collectors.toSet());
        List tagsByCodes = this.participatorTagMdmService.findTagsByCodes((Set)codes);
        Map<String, List<ParticipatorTagMdmVo>> codeMapTag = tagsByCodes.stream().collect(Collectors.groupingBy(ParticipatorTagMdmVo::getParticipatorCode));
        for (TerminalMdmVo terminal : terminalMdmVos) {
            List<ParticipatorTagMdmVo> tags = codeMapTag.get(terminal.getTerminalCode());
            if (CollectionUtils.isEmpty(tags)) continue;
            String tag = "";
            for (ParticipatorTagMdmVo tagMdmVo : tags) {
                String tagDescription = tagMdmVo.getTagDescription();
                if (!StringUtils.isNotBlank((CharSequence)tagDescription)) continue;
                tag = StringUtils.isNotBlank((CharSequence)tag) ? StringUtils.join((Object[])new String[]{tag, ";", tagDescription}) : tagDescription;
            }
            terminal.setTagDescription(tag);
        }
        Page page = new Page();
        page.setTotal(((PageResult)result.getResult()).getCount().longValue());
        page.setRecords((List)terminalMdmVos);
        return page;
    }

    public List<TerminalMdmVo> findByConditions(TerminalMdmPaginationDto terminalMdmPaginationDto) {
        if (terminalMdmPaginationDto == null) {
            terminalMdmPaginationDto = new TerminalMdmPaginationDto();
        }
        MdmTerminalVo reqVo = new MdmTerminalVo();
        reqVo.setTerminalCode(terminalMdmPaginationDto.getTerminalCode());
        reqVo.setTerminalName(terminalMdmPaginationDto.getTerminalName());
        reqVo.setOrgCode(terminalMdmPaginationDto.getOrganization());
        reqVo.setChannel(terminalMdmPaginationDto.getChannel());
        Result result = this.mdmTerminalFeign.listCondition(reqVo);
        if (result.isSuccess()) {
            return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result.getResult(), MdmTerminalVo.class, TerminalMdmVo.class, HashSet.class, ArrayList.class, new String[]{"contacts", "supplys", "channelList", "orgList"}));
        }
        return null;
    }

    public TerminalMdmVo findDetailByRegisterOrName(TerminalMdmPaginationDto terminalMdmPaginationDto) {
        MdmTerminalVo result;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{terminalMdmPaginationDto.getLicenseRegisterNumber(), terminalMdmPaginationDto.getTerminalAddress(), terminalMdmPaginationDto.getTerminalName()})) {
            return null;
        }
        Result registerResult = this.mdmTerminalFeign.findDetailByRegisterOrName(terminalMdmPaginationDto.getLicenseRegisterNumber(), null);
        if (registerResult.isSuccess() && Objects.nonNull(result = (MdmTerminalVo)registerResult.getResult())) {
            return (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(registerResult.getResult(), TerminalMdmVo.class, Set.class, ArrayList.class, new String[0]);
        }
        Result resultByNameAndAddress = this.mdmTerminalFeign.findTerminalByNameOrAddress(terminalMdmPaginationDto.getTerminalName(), terminalMdmPaginationDto.getTerminalAddress());
        if (resultByNameAndAddress != null && resultByNameAndAddress.isSuccess() && Objects.nonNull(resultByNameAndAddress.getResult())) {
            return (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(resultByNameAndAddress.getResult(), TerminalMdmVo.class, Set.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    public TerminalMdmVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new TerminalMdmVo();
        }
        Result result = this.mdmTerminalFeign.query(id, null);
        if (result.isSuccess()) {
            return (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(result.getResult(), TerminalMdmVo.class, Set.class, ArrayList.class, new String[]{"contacts", "supplys", "channelList", "orgList"});
        }
        throw new RuntimeException(result.getMessage());
    }

    @Transactional
    public void save(TerminalMdmVo terminalMdmVo) {
        Validate.notNull((Object)terminalMdmVo, (String)"\u4fdd\u5b58\u7ec8\u7aef\u4fe1\u606f\u5230mdm\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalMdmVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MdmTerminalVo mdmTerminalVo = new MdmTerminalVo();
        BeanUtils.copyProperties((Object)terminalMdmVo, (Object)mdmTerminalVo, (String[])new String[]{"contacts", "supplys"});
        List contactPersonMdms = terminalMdmVo.getContacts();
        List contacts = null;
        if (!CollectionUtils.isEmpty((Collection)contactPersonMdms)) {
            contacts = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contactPersonMdms, TerminalContactMdmVo.class, MdmTerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            mdmTerminalVo.setContacts(contacts);
        }
        mdmTerminalVo.setFromType("cps");
        log.info("\u63a8\u9001mdm\u7ec8\u7aef\u6570\u636e={}", (Object)JSON.toJSONString((Object)mdmTerminalVo));
        Result result = this.mdmTerminalFeign.save(mdmTerminalVo);
        Validate.notNull((Object)result, (String)"\u8c03\u7528mdm\u7684save\u65b9\u6cd5\u5931\u8d25", (Object[])new Object[0]);
        Validate.isTrue((boolean)result.isSuccess(), (String)result.getMessage(), (Object[])new Object[0]);
        Validate.notNull((Object)result.getResult(), (String)"\u672a\u67e5\u627e\u5230\u4fdd\u5b58\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
    }

    public List<TerminalMdmVo> findDetailByCodes(Set<String> codes) {
        List resultList;
        Result result = this.mdmTerminalFeign.queryTerminalAndAttachByCode((List)Lists.newLinkedList(codes));
        if (result.isSuccess() && !CollectionUtils.isEmpty((Collection)(resultList = (List)result.getResult()))) {
            return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)resultList, MdmTerminalVo.class, TerminalMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
        }
        return null;
    }

    public List<TerminalMdmVo> findByPhone(String phone) {
        List resultList;
        if (StringUtils.isBlank((CharSequence)phone)) {
            return Lists.newArrayList();
        }
        Result result = this.mdmTerminalFeign.getTerminalByPhone(phone);
        if (result.isSuccess() && !CollectionUtils.isEmpty((Collection)(resultList = (List)result.getResult()))) {
            return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)resultList, MdmTerminalVo.class, TerminalMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
        }
        return null;
    }
}

