/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.config;

import com.biz.crm.config.JwtAuthorizationTokenFilter;
import com.biz.crm.config.TokenRenewalUtil;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.external.mdm.sdk.event.JwtTokenRequestListener;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.UserRedis;
import com.bizunited.platform.common.configuration.SimpleTenantProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Primary
@ConditionalOnMissingBean(name={"JwtAuthorizationTokenExpandFilter"})
public class JwtAuthorizationTokenExpandFilter
extends JwtAuthorizationTokenFilter {
    @Autowired
    private RedisService redisService;
    @Autowired
    private TokenRenewalUtil tokenRenewalUtil;
    @Autowired
    private SimpleTenantProperties simpleTenantProperties;
    @Autowired(required=false)
    private List<JwtTokenRequestListener> jwtTokenRequestListeners;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object o;
        Cookie cookie;
        String token = request.getHeader("loginUserToken");
        if (token == null && (cookie = CookiesUtil.getCookieByName((HttpServletRequest)request, (String)"loginUserToken")) != null) {
            token = cookie.getValue();
        }
        if ((o = this.redisService.get("token:" + token)) == null) {
            o = this.tokenRenewalUtil.loginRenewal(token);
        }
        if (o != null) {
            UserRedis userRedis = (UserRedis)o;
            LoginUserDetails loginUserDetails = new LoginUserDetails(request);
            loginUserDetails.setTenantCode(this.simpleTenantProperties.getDefaultAppCode());
            loginUserDetails.setAccount(userRedis.getUsername());
            loginUserDetails.setRealName(userRedis.getRealname());
            loginUserDetails.setUsertype(userRedis.getUsertype());
            loginUserDetails.setPostCode(userRedis.getPoscode());
            loginUserDetails.setPostName(userRedis.getPosname());
            loginUserDetails.setOrgCode(userRedis.getOrgcode());
            loginUserDetails.setOrgName(userRedis.getOrgname());
            loginUserDetails.setConsumerCode(userRedis.getCustcode());
            loginUserDetails.setConsumerName(userRedis.getCustname());
            loginUserDetails.setFromType(userRedis.getFromtype());
            loginUserDetails.setLanguage(userRedis.getLanguage());
            loginUserDetails.setOpenId(userRedis.getOpenId());
            Boolean bool = false;
            if (this.jwtTokenRequestListeners != null) {
                for (JwtTokenRequestListener eventListener : this.jwtTokenRequestListeners) {
                    bool = eventListener.onFilter(userRedis.getCustcode(), userRedis.getUsertype());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)userRedis.getUsername()) && bool.booleanValue()) {
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)loginUserDetails.getAccount(), (Object)loginUserDetails.getPassword(), Collections.singletonList(new SimpleGrantedAuthority("ADMIN")));
                authentication.setDetails((Object)loginUserDetails);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

