/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.MaterialMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialGroupMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMediaMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductLevelMdmVo;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.biz.crm.nebular.mdm.material.MaterialMdmPaginationDto;
import com.biz.crm.nebular.mdm.material.MdmMaterialMediaRespVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MaterialMdmServiceExpandImpl"})
public class MaterialMdmServiceImpl
implements MaterialMdmService {
    @Autowired
    private MdmMaterialFeign mdmMaterialFeign;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<MaterialMdmVo> findByConditions(Pageable pageable, com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto materialMdmPaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        materialMdmPaginationDto.setPageNum(Integer.valueOf(pageable.getPageNumber()));
        materialMdmPaginationDto.setPageSize(Integer.valueOf(pageable.getPageSize()));
        MaterialMdmPaginationDto req = (MaterialMdmPaginationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialMdmPaginationDto, MaterialMdmPaginationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Result result = this.mdmMaterialFeign.pageCpsList(req);
        Page page = new Page();
        if (result != null && result.isSuccess()) {
            List materialRespVos = ((PageResult)result.getResult()).getData().stream().map(item -> {
                MaterialMdmVo vo = (MaterialMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(item, MaterialMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                List mdmLevelMdmVos = item.getProductLevels();
                if (!CollectionUtils.isEmpty((Collection)mdmLevelMdmVos)) {
                    List levelMdmVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)mdmLevelMdmVos, MdmProductLevelVo.class, ProductLevelMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                    vo.setProductLevels(levelMdmVos);
                } else {
                    vo.setProductLevels((List)Lists.newArrayList());
                }
                List picList = item.getPicList();
                if (!CollectionUtils.isEmpty((Collection)picList)) {
                    List mediaMdmVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)picList, MdmMaterialMediaRespVo.class, MaterialMediaMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                    vo.setMaterialMedias(mediaMdmVos);
                } else {
                    vo.setMaterialMedias((List)Lists.newArrayList());
                }
                return vo;
            }).collect(Collectors.toList());
            page.setCurrent(((PageResult)result.getResult()).getCount().longValue());
            page.setRecords(materialRespVos);
        } else {
            page.setRecords((List)Lists.newArrayList());
        }
        return page;
    }

    public Page<MaterialGroupMdmVo> findByConditions(Pageable pageable, MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        materialGroupMdmPaginationDto.setPageNum(Integer.valueOf(pageable.getPageNumber()));
        materialGroupMdmPaginationDto.setPageSize(Integer.valueOf(pageable.getPageSize()));
        MdmMaterialGroupReqVo req = (MdmMaterialGroupReqVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialGroupMdmPaginationDto, MdmMaterialGroupReqVo.class, HashSet.class, ArrayList.class, new String[0]);
        Result result = this.mdmMaterialFeign.pageGroupCpsList(req);
        Page page = new Page();
        if (result != null && result.isSuccess()) {
            List materialGroupMdmVos = ((PageResult)result.getResult()).getData().stream().map(item -> {
                MaterialGroupMdmVo vo = new MaterialGroupMdmVo();
                BeanUtils.copyProperties((Object)item, (Object)vo, (String[])new String[]{"materialNum"});
                try {
                    BigDecimal materialNum = new BigDecimal(String.valueOf(item.getMaterialNum())).setScale(4, RoundingMode.HALF_UP);
                    vo.setMaterialNum(materialNum);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("materialNum\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                List mdmMaterialList = item.getMaterialList();
                if (!CollectionUtils.isEmpty((Collection)mdmMaterialList)) {
                    List materialMdmVos = mdmMaterialList.stream().map(temp -> {
                        MaterialMdmVo materialMdmVo = (MaterialMdmVo)this.nebulaToolkitService.copyObjectByWhiteList(temp, MaterialMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                        List mdmLevelMdmVos = temp.getProductLevels();
                        if (!CollectionUtils.isEmpty((Collection)mdmLevelMdmVos)) {
                            List levelMdmVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)mdmLevelMdmVos, MdmProductLevelVo.class, ProductLevelMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                            materialMdmVo.setProductLevels(levelMdmVos);
                        } else {
                            materialMdmVo.setProductLevels((List)Lists.newArrayList());
                        }
                        List picList = temp.getPicList();
                        if (!CollectionUtils.isEmpty((Collection)picList)) {
                            List mediaMdmVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)picList, MdmMaterialMediaRespVo.class, MaterialMediaMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
                            materialMdmVo.setMaterialMedias(mediaMdmVos);
                        } else {
                            materialMdmVo.setMaterialMedias((List)Lists.newArrayList());
                        }
                        return materialMdmVo;
                    }).collect(Collectors.toList());
                    vo.setMaterialMdmVos(materialMdmVos);
                } else {
                    vo.setMaterialMdmVos((List)Lists.newArrayList());
                }
                return vo;
            }).collect(Collectors.toList());
            page.setCurrent(((PageResult)result.getResult()).getCount().longValue());
            page.setRecords(materialGroupMdmVos);
        } else {
            page.setRecords((List)Lists.newArrayList());
        }
        return page;
    }
}

