/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.controller;

import com.biz.crm.cps.external.mdm.sdk.service.ParticipatorMdmService;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u53c2\u4e0e\u8005"})
@Controller
@RequestMapping(value={"/v1/mdm/participator"})
public class ParticipatorMdmController {
    private static final Logger log = LoggerFactory.getLogger(ParticipatorMdmController.class);
    @Autowired
    private ParticipatorMdmService participatorMdmService;
    @Autowired(required=false)
    private WXOpenVoService wxOpenService;

    @ApiOperation(value="\u7ed1\u5b9a\u5fae\u4fe1")
    @GetMapping(value={"/bindWxOpenId"})
    public ModelAndView bindWxOpenId(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam String code, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType) {
        String openid = this.participatorMdmService.bindWxOpenId(code, appType);
        ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openid);
        return mv;
    }

    @ApiOperation(value="\u83b7\u53d6openId")
    @GetMapping(value={"/findOpenId"})
    public ModelAndView findOpenId(@ApiParam(value="\u91cd\u5b9a\u5411url") @RequestParam String redirectUri, @RequestParam(required=false) String code, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType, HttpServletRequest request) {
        Validate.isTrue((this.isWeChat(request) && StringUtils.isNotBlank((CharSequence)code) ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u73af\u5883\u4e0bcode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenService.findWebViewAccessToken(code, appType);
        String openId = null;
        if (accessTokenRespVo != null) {
            openId = accessTokenRespVo.getOpenid();
        }
        ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openId);
        return mv;
    }

    private boolean isWeChat(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        return userAgent != null && userAgent.indexOf("micromessenger") != -1;
    }
}

