/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.cps.external.feign.service.CpsMdmCustomerMsgFeign;
import com.biz.crm.cps.external.mdm.sdk.dto.DealerMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.event.DealerMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.service.DealerMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerCommunicationMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerContactPersonMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerMdmVo;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TDealerMdmServiceExpandImpl"})
public class DealerMdmServiceImpl
implements DealerMdmService {
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private CpsMdmCustomerMsgFeign cpsMdmCustomerMsgFeign;
    @Autowired(required=false)
    private List<DealerMdmEventListener> dealerMdmEventListeners;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<DealerMdmVo> findByCustomerCodes(Collection<String> subtract) {
        if (CollectionUtils.isEmpty(subtract)) {
            return null;
        }
        Result listResult = this.mdmCustomerMsgFeign.queryByCustomerCodeList((List)Lists.newLinkedList(subtract));
        if (!listResult.isSuccess()) {
            return null;
        }
        List result = (List)listResult.getResult();
        List<DealerMdmVo> dealerMdmVos = this.mdmCustomerToDealerMdm(result);
        return dealerMdmVos;
    }

    public Page<DealerMdmVo> findByConditions(Pageable pageable, DealerMdmPaginationDto dealerMdmPaginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dealerMdmPaginationDto == null) {
            dealerMdmPaginationDto = new DealerMdmPaginationDto();
        }
        MdmCustomerMsgReqVo vo = new MdmCustomerMsgReqVo();
        if (!CollectionUtils.isEmpty(this.dealerMdmEventListeners)) {
            LinkedList list = Lists.newLinkedList();
            for (DealerMdmEventListener event : this.dealerMdmEventListeners) {
                List codes = event.onFind();
                list.addAll(codes);
            }
            vo.setCustomerCodeList((List)list);
        }
        vo.setCustomerCode(dealerMdmPaginationDto.getCustomerCode());
        vo.setCustomerName(dealerMdmPaginationDto.getCustomerName());
        vo.setOrgCode(dealerMdmPaginationDto.getOrgCode());
        vo.setCustomerType(dealerMdmPaginationDto.getCustomerType());
        vo.setPageSize(Integer.valueOf(pageable.getPageSize()));
        vo.setPageNum(Integer.valueOf(pageable.getPageNumber()));
        Result result = this.cpsMdmCustomerMsgFeign.list(vo);
        if (!result.isSuccess()) {
            return null;
        }
        List<DealerMdmVo> dealerMdmVos = this.mdmCustomerToDealerMdm(((PageResult)result.getResult()).getData());
        Page page = new Page();
        page.setTotal(((PageResult)result.getResult()).getCount().longValue());
        page.setRecords(dealerMdmVos);
        return page;
    }

    private List<DealerMdmVo> mdmCustomerToDealerMdm(List<MdmCustomerMsgRespVo> result) {
        LinkedList dealerMdmVos = Lists.newLinkedList();
        for (MdmCustomerMsgRespVo msgRespVo : result) {
            DealerMdmVo dealerMdmVo = (DealerMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)msgRespVo, DealerMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
            dealerMdmVo.setCustomerCode(msgRespVo.getCustomerCode());
            dealerMdmVo.setErpCustomerCode(msgRespVo.getErpCode());
            dealerMdmVo.setChannelCode(msgRespVo.getChannel());
            dealerMdmVo.setLegalRepresent(msgRespVo.getLegalRepresentative());
            List mdmCustomerContactVos = msgRespVo.getMdmCustomerContactVos();
            HashSet dealerContactPersons = Sets.newHashSet();
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerContactVos)) {
                for (MdmCustomerContactRespVo mdmCustomerContactVo : mdmCustomerContactVos) {
                    DealerContactPersonMdmVo dealerContactPersonMdmVo = new DealerContactPersonMdmVo();
                    dealerContactPersonMdmVo.setContactPersonName(mdmCustomerContactVo.getContactName());
                    dealerContactPersonMdmVo.setContactPersonPhone(mdmCustomerContactVo.getContactPhone());
                    dealerContactPersonMdmVo.setDealerId(msgRespVo.getId());
                    dealerContactPersons.add(dealerContactPersonMdmVo);
                }
            }
            dealerMdmVo.setDealerContactPersons((Set)dealerContactPersons);
            List mdmCustomerDockingVos = msgRespVo.getMdmCustomerDockingVos();
            HashSet dealerCommunicationMdmVos = Sets.newHashSet();
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerDockingVos)) {
                for (MdmCustomerDockingRespVo mdmCustomerDockingVo : mdmCustomerDockingVos) {
                    DealerCommunicationMdmVo dealerCommunicationMdmVo = new DealerCommunicationMdmVo();
                    dealerCommunicationMdmVo.setPositionCode(mdmCustomerDockingVo.getPositionCode());
                    dealerCommunicationMdmVo.setPositionName(mdmCustomerDockingVo.getPositionName());
                    dealerCommunicationMdmVo.setUserCode(mdmCustomerDockingVo.getUserName());
                    dealerCommunicationMdmVo.setUserName(mdmCustomerDockingVo.getFullName());
                    dealerCommunicationMdmVo.setCommunicationOrgCode(mdmCustomerDockingVo.getOrgCode());
                    dealerCommunicationMdmVo.setCommunicationOrgName(mdmCustomerDockingVo.getOrgName());
                    dealerCommunicationMdmVo.setCommunicationContact(mdmCustomerDockingVo.getContactPhone());
                    dealerCommunicationMdmVo.setDealerId(msgRespVo.getId());
                    dealerCommunicationMdmVos.add(dealerCommunicationMdmVo);
                }
            }
            dealerMdmVo.setDealerCommunications((Set)dealerCommunicationMdmVos);
            dealerMdmVos.add(dealerMdmVo);
        }
        return dealerMdmVos;
    }
}

