/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.notifier;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.cps.external.mdm.sdk.event.DealerMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerCommunicationMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerContactPersonMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="DEALER_REFRESH", consumerGroup="DEALER_REFRESH${rocketmq.environment-variable}")
public class DealerRefreshConsumer
implements RocketMQListener<RocketMQMessageBody> {
    private static final Logger log = LoggerFactory.getLogger(DealerRefreshConsumer.class);
    @Autowired
    private DealerMdmEventListener dealerMdmEventListener;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public void onMessage(RocketMQMessageBody message) {
        if (null == message) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        String json = JSON.toJSONString((Object)message);
        if (StringUtils.isBlank((CharSequence)message.getId())) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {}", (Object)json);
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = " + json, new String[]{"\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25"});
        }
        try {
            this.handleMessage(message);
        }
        catch (InterruptedException e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
        }
    }

    protected void handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("\u8fdb\u9500\u5546\u4fe1\u606f\u66f4\u65b0\u5f00\u59cb-------------");
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        log.info("\u8fdb\u9500\u5546\u4fe1\u606f\uff1a{}", (Object)msg);
        MdmCustomerMsgRespVo customerMsgRespVo = (MdmCustomerMsgRespVo)JSON.parseObject((String)msg, MdmCustomerMsgRespVo.class);
        if (customerMsgRespVo == null) {
            log.info("\u8fdb\u9500\u5546\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        DealerMdmVo dealerMdmVo = this.convertModel(customerMsgRespVo);
        log.info("\u8fdb\u9500\u5546\u4fe1\u606f\u8f6c\u6362\u540e\uff1a{}", (Object)dealerMdmVo);
        dealerMdmVo.setId(null);
        this.dealerMdmEventListener.onChange(null, dealerMdmVo);
        log.info("\u8fdb\u9500\u5546\u4fe1\u606f\u66f4\u65b0\u7ed3\u675f-------------");
    }

    private DealerMdmVo convertModel(MdmCustomerMsgRespVo msgRespVo) {
        DealerMdmVo dealerMdmVo = (DealerMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)msgRespVo, DealerMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
        dealerMdmVo.setCustomerCode(msgRespVo.getCustomerCode());
        dealerMdmVo.setErpCustomerCode(msgRespVo.getErpCode());
        dealerMdmVo.setChannelCode(msgRespVo.getChannel());
        dealerMdmVo.setLegalRepresent(msgRespVo.getLegalRepresentative());
        List mdmCustomerContactVos = msgRespVo.getMdmCustomerContactVos();
        HashSet dealerContactPersons = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)mdmCustomerContactVos)) {
            for (MdmCustomerContactRespVo mdmCustomerContactVo : mdmCustomerContactVos) {
                DealerContactPersonMdmVo dealerContactPersonMdmVo = new DealerContactPersonMdmVo();
                dealerContactPersonMdmVo.setContactPersonName(mdmCustomerContactVo.getContactName());
                dealerContactPersonMdmVo.setContactPersonPhone(mdmCustomerContactVo.getContactPhone());
                dealerContactPersonMdmVo.setDealerId(msgRespVo.getId());
                dealerContactPersons.add(dealerContactPersonMdmVo);
            }
        }
        dealerMdmVo.setDealerContactPersons((Set)dealerContactPersons);
        List mdmCustomerDockingVos = msgRespVo.getMdmCustomerDockingVos();
        HashSet dealerCommunicationMdmVos = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)mdmCustomerDockingVos)) {
            for (MdmCustomerDockingRespVo mdmCustomerDockingVo : mdmCustomerDockingVos) {
                DealerCommunicationMdmVo dealerCommunicationMdmVo = new DealerCommunicationMdmVo();
                dealerCommunicationMdmVo.setPositionCode(mdmCustomerDockingVo.getPositionCode());
                dealerCommunicationMdmVo.setPositionName(mdmCustomerDockingVo.getPositionName());
                dealerCommunicationMdmVo.setUserCode(mdmCustomerDockingVo.getUserName());
                dealerCommunicationMdmVo.setUserName(mdmCustomerDockingVo.getFullName());
                dealerCommunicationMdmVo.setCommunicationOrgCode(mdmCustomerDockingVo.getOrgCode());
                dealerCommunicationMdmVo.setCommunicationOrgName(mdmCustomerDockingVo.getOrgName());
                dealerCommunicationMdmVo.setCommunicationContact(mdmCustomerDockingVo.getContactPhone());
                dealerCommunicationMdmVo.setDealerId(msgRespVo.getId());
                dealerCommunicationMdmVos.add(dealerCommunicationMdmVo);
            }
        }
        dealerMdmVo.setDealerCommunications((Set)dealerCommunicationMdmVos);
        return dealerMdmVo;
    }
}

