package com.biz.crm.cps.external.mdm.sdk.constant;

/**
 * MQ 常量
 *
 * @author: luoqi
 * @Date: 2020-9-27 19:51
 * @version: V1.0
 * @Description:
 */
public class RocketMQConstant {

  /**
   * TOPIC 常量
   *
   * @author: luoqi
   * @Date: 2020-9-27 19:51
   * @version: V1.0
   * @Description:
   */
  public static class TOPIC {

    /**
     * 全局公用 TOPIC
     *
     * @author: luoqi
     * @Date: 2020-10-30 10:59
     * @version: V1.0
     * @Description:
     */
    public static class GLOBAL {

      public static final String TOPIC_GLOBAL = "TOPIC_GLOBAL";
    }
  }


  /**
   * 定义消费组
   */
  public static class CONSUMER_GROUP {

    public static final String TEST = "CONSUMER_GROUP_TEST";
    public static final String ORDER = "CONSUMER_GROUP_ORDER";

    //客户可购清单刷新
    public static final String CUS_AVAILBLELIST_REFRSH = "CUS_AVAILBLELIST_REFRSH";

    //客户可购清单刷新促销
    public static final String CUS_AVAILBLELIST_REFRSH_PROMOTION = "CUS_AVAILBLELIST_REFRSH_PROMOTION";

    //修改商品層級，同时刷新产品层级的可购清单
    public static final String AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL = "AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL";

    //终端可购清单刷新
    public static final String TERMINAL_AVAILBLELIST_REFRSH = "TERMINAL_AVAILBLELIST_REFRSH";

    //终端信息修改
    public static final String TERMINAL_REFRESH = "TERMINAL_REFRESH";

    //客户标签刷新
    public static final String CUSTOMER_TAG_REFRESH = "CUSTOMER_TAG_REFRESH";

    //可购清单删除商品
    public static final String AVAILBLELIST_DELPRODUCT = "AVAILBLELIST_DELPRODUCT";

    //清空购物车消费者
    public static final String CLEAR_SHOPPING_CAR_CONSUMER = "CLEAR_SHOPPING_CAR";

    //可购清单更新商品
    public static final String AVAILBLELIST_UPDATEPRODUCT = "AVAILBLELIST_UPDATEPRODUCT";

    //新增商品的時候刷新可夠清單
    public static final String AVAILBLELIST_REFRSH_ADD_PRODUCT = "CUS_AVAILBLELIST_REFRSH_ADD_PRODUCT";

    //验证websocket
    public static final String WEBSOCKET_SESSION = "WEBSOCKET_SESSION";

    //excel 导入 WEBSOCKET 消息推送
    public static final String EXCEL_IMPORT_WEBSOCKET_MSG = "EXCEL_IMPORT_WEBSOCKET_MSG";

    //可购清单更新商品
    public static final String CRMLOG = "CRMLOG";
    //终端新增事件（审批通过）
    public static final String TERMINAL_NEW_OR_PASS = "TERMINAL_NEW_OR_PASS";
    /**
     * TPM-活动审批通过和活动关闭的消息
     */
    public static final String TPM_ACT_APPROVED_AND_CLOSED = "TPM_ACT_APPROVED_AND_CLOSED";

    /**
     * 拜访计划结算
     */
    public static final String VISIT_PLAN_INFO_SETTLEMENT = "VISIT_PLAN_INFO_SETTLEMENT";
    /**
     * SFA活动执行明细解析
     */
    public static final String SFA_ACTIVITY_EXECUTION_RESOLVE = "SFA_ACTIVITY_EXECUTION_RESOLVE";

    //可购规则导入消费者
    public static final String AVAILABLE_RULE_IMPORT_CONSUMER = "AVAILABLE_RULE_IMPORT_CONSUMER";

    //指标完成记录
    public static final String INDEX_ACCOMPLISH_RECORDS = "INDEX_ACCOMPLISH_RECORDS";
    //新增客户完成 mq标签
    public static final String INSERT_CLIENT = "INSERT_CLIENT";

    //拜访步骤，业务动态
    public static final String CUSTOMER_BUSINESS_DETAIL = "CUSTOMER_BUSINESS_DETAIL";

    //积分
    public static final String INTEGRAL_DETAIL = "INTEGRAL_DETAIL";

    //职位-新增
    public static final String POSITION_ADD_TAG = "POSITION_ADD_TAG";
    //职位-编辑
    public static final String POSITION_UPDATE_TAG = "POSITION_UPDATE_TAG";
    //职位-删除
    public static final String POSITION_DELETE_TAG = "POSITION_DELETE_TAG";

    //流程角色-新增
    public static final String BPM_ROLE_ADD_TAG = "BPM_ROLE_ADD_TAG";
    //流程角色-编辑
    public static final String BPM_ROLE_UPDATE_TAG = "BPM_ROLE_UPDATE_TAG";
    //流程角色-删除
    public static final String BPM_ROLE_DELETE_TAG = "BPM_ROLE_DELETE_TAG";

    //职位关联流程角色-新增
    public static final String POSITION_REL_BPM_ROLE_ADD_TAG = "POSITION_REL_BPM_ROLE_ADD_TAG";
    //职位关联流程角色-删除
    public static final String POSITION_REL_BPM_ROLE_DELETE_TAG = "POSITION_REL_BPM_ROLE_DELETE_TAG";

    /**
     * 拜访日进度报表结算
     */
    public static final String VISIT_DAY_RATE_SETTLEMENT = "VISIT_DAY_RATE_SETTLEMENT";
  }

  /**
   * 定义crm所有tag的地方
   */
  public static class CRM_MQ_TAG {

    //TEST
    public static final String TEST = "TEST";
    //excel 导入 WEBSOCKET 消息推送
    public static final String EXCEL_IMPORT_WEBSOCKET_MSG = "EXCEL_IMPORT_WEBSOCKET_MSG";
    //客户可购清单刷新
    public static final String CUS_AVAILBLELIST_REFRSH = "CUS_AVAILBLELIST_REFRSH";

    //客户新增事件
    public static final String CUSTOMER_INSERT = "CUSTOMER_INSERT";

    //终端信息修改
    public static final String TERMINAL_REFRESH = "TERMINAL_REFRESH";

    //客户标签刷新
    public static final String CUSTOMER_TAG_REFRESH = "CUSTOMER_TAG_REFRESH";

    //客户可购清单刷新促销
    public static final String CUS_AVAILBLELIST_REFRSH_PROMOTION = "CUS_AVAILBLELIST_REFRSH_PROMOTION";

    //终端可购清单刷新
    public static final String TERMINAL_AVAILBLELIST_REFRSH = "TERMINAL_AVAILBLELIST_REFRSH";

    //终端新增事件（审批通过）
    public static final String TERMINAL_NEW_OR_PASS = "TERMINAL_NEW_OR_PASS";

    //可购清单删除商品
    public static final String AVAILBLELIST_DELPRODUCT = "AVAILBLELIST_DELPRODUCT";

    //可购清单更新商品
    public static final String AVAILBLELIST_UPDATEPRODUCT = "AVAILBLELIST_UPDATEPRODUCT";

    //新增商品的時候刷新可夠清單
    public static final String AVAILBLELIST_REFRSH_ADD_PRODUCT = "AVAILBLELIST_REFRSH_ADD_PRODUCT";

    //修改商品層級，同时刷新产品层级的可购清单
    public static final String AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL = "AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL";

    //验证websocket
    public static final String WEBSOCKET_SESSION = "WEBSOCKET_SESSION";

    //日志处理
    public static final String CRMLOG = "CRMLOG";

    //清空购物车主题
    public static final String CLEAR_SHOPPING_CAR = "CLEAR_SHOPPING_CAR";

    /**
     * TPM-活动审批通过和活动关闭的消息
     */
    public static final String TPM_ACT_APPROVED_AND_CLOSED = "TPM_ACT_APPROVED_AND_CLOSED";

    /**
     * 拜访计划结算
     */
    public static final String VISIT_PLAN_INFO_SETTLEMENT = "VISIT_PLAN_INFO_SETTLEMENT";
    /**
     * 拜访日进度报表结算
     */
    public static final String VISIT_DAY_RATE_SETTLEMENT = "VISIT_DAY_RATE_SETTLEMENT";
    /**
     * SFA活动执行明细解析
     */
    public static final String SFA_ACTIVITY_EXECUTION_RESOLVE = "SFA_ACTIVITY_EXECUTION_RESOLVE";

    //可购规则导入mq标签
    public static final String AVAILABLE_RULE_IMPORT_TAG = "AVAILABLE_RULE_IMPORT_TAG";

    //指标完成记录mq标签
    public static final String INDEX_ACCOMPLISH_RECORDS_TAG = "INDEX_ACCOMPLISH_RECORDS_TAG";
    //新增客户完成 mq标签
    public static final String INSERT_CLIENT_TAG = "INSERT_CLIENT_TAG";

    //拜访步骤，业务动态mq标签
    public static final String CUSTOMER_BUSINESS_DETAIL_TAG = "CUSTOMER_BUSINESS_DETAIL_TAG";

    //积分mq标签
    public static final String INTEGRAL_DETAIL_TAG = "INTEGRAL_DETAIL_TAG";

    //职位-新增
    public static final String POSITION_ADD_TAG = "POSITION_ADD_TAG";
    //职位-编辑
    public static final String POSITION_UPDATE_TAG = "POSITION_UPDATE_TAG";
    //职位-删除
    public static final String POSITION_DELETE_TAG = "POSITION_DELETE_TAG";

    //流程角色-新增
    public static final String BPM_ROLE_ADD_TAG = "BPM_ROLE_ADD_TAG";
    //流程角色-编辑
    public static final String BPM_ROLE_UPDATE_TAG = "BPM_ROLE_UPDATE_TAG";
    //流程角色-删除
    public static final String BPM_ROLE_DELETE_TAG = "BPM_ROLE_DELETE_TAG";

    //职位关联流程角色-新增
    public static final String POSITION_REL_BPM_ROLE_ADD_TAG = "POSITION_REL_BPM_ROLE_ADD_TAG";
    //职位关联流程角色-删除
    public static final String POSITION_REL_BPM_ROLE_DELETE_TAG = "POSITION_REL_BPM_ROLE_DELETE_TAG";

  }

}
