package com.biz.crm.cps.external.mdm.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * mdm侧物料分页查询dto
 *
 * @Author: hecheng
 */
@Data
@ApiModel
public class MaterialGroupMdmPaginationDto implements Serializable {

  private static final long serialVersionUID = 925824147679953235L;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
  /**
   * 物料组编码
   */
  @ApiModelProperty("物料组编码")
  private String materialGroupCode;
  /**
   * 物料组编码集合
   */
  @ApiModelProperty("物料组编码集合")
  private List<String> materialGroupCodes;

  /**
   * 物料编码集合
   */
  @ApiModelProperty("物料编码集合")
  private List<String> materialCodes;
  /**
   * 修改/创建开始时间
   */
  @ApiModelProperty("修改开始时间")
  private String startDate;
  /**
   * 修改/创建结束时间
   */
  @ApiModelProperty("修改结束时间")
  private String endDate;

  /**
   * 每页数据的数量
   */
  private Integer pageSize;

  /**
   * 页码
   */
  private Integer pageNum;
}
