package com.biz.crm.cps.external.mdm.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * mdm侧商品层级分页查询dto
 *
 * @Author: hecheng
 */
@Data
@ApiModel
public class ProductLevelMdmPaginationDto implements Serializable {

  private static final long serialVersionUID = 925824147679953235L;

  /**
   * 商品层级编码
   * <pre>
   *   "brand":"品牌"
   *   "series":"系列"
   *   "max":"大类"
   *   "min":"细类"
   * </pre>
   */
  @ApiModelProperty("商品层级类型")
  private String productLevelType;
  /**
   * 商品层级编码集合
   */
  @ApiModelProperty("商品层级编码集合")
  private List<String> productLevelCodes;


}
