package com.biz.crm.cps.external.mdm.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * mdm侧终端分页查询dto
 *
 * @Author: hefan
 * @Date: 2021/7/22 10:44
 */
@Data
@ApiModel
public class TerminalMdmPaginationDto implements Serializable {
  private static final long serialVersionUID = 925824147679953235L;

  /**
   * 分利终端编码
   */
  @ApiModelProperty("分利终端编码")
  private String terminalCode;

  /**
   * 分利终端名称
   */
  @ApiModelProperty("分利终端名称")
  private String terminalName;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 营业执照编码
   */
  @ApiModelProperty("营业执照编码")
  private String licenseRegisterNumber;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /**
   * 终端标签
   */
  @ApiModelProperty("终端标签")
  private String terminalLabel;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  @ApiModelProperty("不包含门店编码查询条件")
  private List<String> notIncludeTerminalCodeList;

}
