package com.biz.crm.cps.external.mdm.sdk.event;

import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;

import java.util.List;

/**
 * mdm模块向上通知----终端事件
 * @author hefan
 */
public interface TerminalMdmEventListener {

  /**
   * 当外部系统的主数据模块的终端信息发生变更时
   * @param oldVo
   * @param newVo
   */
  String onChange(TerminalMdmVo oldVo, TerminalMdmVo newVo);

  /**
   * 当查询外部系统的终端信息时，上层模块返回已使用到的终端code
   * @return
   */
  List<String> onFind();
}
