package com.biz.crm.cps.external.mdm.sdk.service;

import com.biz.crm.cps.external.mdm.sdk.vo.DictTypeVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import java.util.List;

/**
 * 在外部mdm系统操作数据字典的service
 *
 * @author HuaHongQiang
 */
public interface DictMdmService {

  /**
   * 根据dictTypeCodes(字典类型编码)获取数据字典信息
   *
   * @param dictTypeCodes
   * @return
   */
  List<DictTypeVo> findByTypeCodes(List<String> dictTypeCodes);

  /**
   * 根据dictTypeCode(字典类型编码)获取数据字典信息,以升序Sort排序
   *
   * @param dictTypeCode 字典类型编码（或者路径编码）
   * @return
   */
  List<DictVo> findByTypeCode(String dictTypeCode);

}
