package com.biz.crm.cps.external.mdm.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialGroupMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import org.springframework.data.domain.Pageable;

/**
 * 在外部mdm系统操作物料信息的service
 *
 * @author hecheng
 */
public interface MaterialMdmService {

  /**
   * 分页条件查询外部已经存在的物料数据
   * <pre>
   *  1  物料信息
   *  2  包含物料所属的层级 从子节点到最上层父节点
   *  </pre>
   *
   * @param pageable
   * @param materialMdmPaginationDto
   * @return
   */
  Page<MaterialMdmVo> findByConditions(Pageable pageable, MaterialMdmPaginationDto materialMdmPaginationDto);
  /**
   * 分页条件查询外部已经存在的物料数据
   * <pre>
   *  1  物料组信息
   *  2  物料信息
   *  3  物料包含物料所属的层级 从子节点到最上层父节点
   *  </pre>
   *
   * @param pageable
   * @param materialGroupMdmPaginationDto
   * @return
   */
  Page<MaterialGroupMdmVo> findByConditions(Pageable pageable, MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto);

}
