package com.biz.crm.cps.external.mdm.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.mdm.sdk.dto.ProductLevelMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.ProductMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductLevelMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductMdmVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 在外部mdm系统操作商品信息的service
 *
 * @author hecheng
 */
public interface ProductMdmService {

  /**
   * 分页条件查询外部已经存在的商品数据
   * <pre>
   *  1  包含商品所属的层级 从子节点到最上层父节点
   *  2  包含商品所属的物料信息
   *  </pre>
   *
   * @param pageable
   * @param productMdmPaginationDto
   * @return
   */
  Page<ProductMdmVo> findByConditions(Pageable pageable, ProductMdmPaginationDto productMdmPaginationDto);

  /**
   * 分页查询商品层级数据
   *
   * @param pageable
   * @param productLevelMdmPaginationDto
   * @return
   */
  Page<ProductLevelMdmVo> findByConditions(Pageable pageable,
      ProductLevelMdmPaginationDto productLevelMdmPaginationDto);

}
