package com.biz.crm.cps.external.mdm.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 在外部mdm系统操作终端信息的service
 *
 * @author hefan
 */
public interface TerminalMdmService {

  /**
   * 分页条件查询外部已经存在的终端数据
   *
   * @param pageable
   * @param terminalMdmPaginationDto
   * @return
   */
  Page<TerminalMdmVo> findByConditions(Pageable pageable, TerminalMdmPaginationDto terminalMdmPaginationDto);

  /**
   * 条件查询外部已经存在的终端数据
   *
   * @param terminalMdmPaginationDto
   * @return
   */
  List<TerminalMdmVo> findByConditions(TerminalMdmPaginationDto terminalMdmPaginationDto);

  /**
   * 根据营业执照编码或终端名称和地址进行查询
   * @param terminalMdmPaginationDto 查询dto
   * @return 终端详情
   */
  TerminalMdmVo findDetailByRegisterOrName(TerminalMdmPaginationDto terminalMdmPaginationDto);

  /**
   * 根据主键查询终端信息
   * @param id 主键
   * @return 终端详情
   */
  TerminalMdmVo findById(String id);

  /**
   * 保存终端信息到mdm
   * @param terminalMdmVo 终端信息
   * @return
   */
  void save(TerminalMdmVo terminalMdmVo);

  /**
   * 根据code集合查询明细
   * @param codes
   * @return
   */
  List<TerminalMdmVo> findDetailByCodes(Set<String> codes);

  /**
   * 通过电话号码查询终端信息
   * @param phone
   * @return
   */
  List<TerminalMdmVo> findByPhone(String phone);

  /**
   * 切换终端
   *
   * @param terminalCode
   */
  void handleChangeTerminal(String terminalCode);
}
