package com.biz.crm.cps.external.mdm.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户标签
 *
 * @author ning.zhang
 * @date 2022/1/5
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerTagMdmVo", description = "客户标签")
public class CustomerTagMdmVo {

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String clientCode;

    /**
     * 标签类型
     */
    @ApiModelProperty("标签类型 0 不可删除 1 手动增删")
    private String tagType;

    /**
     * 标签描述
     */
    @ApiModelProperty("标签描述")
    private String tagDescription;
}