package com.biz.crm.cps.external.mdm.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 分利经销商联系人VO
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DealerCommunicationMdmVo", description = "分利经销商对接人VO")
public class DealerCommunicationMdmVo extends BaseIdVo {

  /**
   * 对接人职位编码
   */
  @ApiModelProperty("对接人职位编码")
  private String positionCode;

  /**
   * 对接人职位名称
   */
  @ApiModelProperty("对接人职位名称")
  private String positionName;

  /**
   * 对接人用户名编码
   */
  @ApiModelProperty("对接人用户名编码")
  private String userCode;

  /**
   * 对接人用户名
   */
  @ApiModelProperty("对接人用户名")
  private String userName;

  /**
   * 对接人所属组织编码
   */
  @ApiModelProperty("对接人所属组织编码")
  private String communicationOrgCode;

  /**
   * 对接人所属组织
   */
  @ApiModelProperty("对接人所属组织")
  private String communicationOrgName;

  /**
   * 对接人联系方式
   */
  @ApiModelProperty("对接人联系方式")
  private String communicationContact;

  /**
   * 经销商id
   */
  @ApiModelProperty("经销商id")
  private String dealerId;

}
