package com.biz.crm.cps.external.mdm.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DealerMdmVo", description = "分利经销商实体信息")
public class DealerMdmVo extends TenantFlagOpVo {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelCode;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区/县编码
   */
  @ApiModelProperty("区/县编码")
  private String districtCode;

  /**
   * 区/县名称
   */
  @ApiModelProperty("区/县名称")
  private String districtName;

  /**
   * 客户法人代表
   */
  @ApiModelProperty("客户法人代表")
  private String legalRepresent;

  /**
   * 客户联系方式
   */
  @ApiModelProperty("客户联系方式")
  private String customerContact;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;

  /**
   * 联系人信息
   */
  @ApiModelProperty("联系人信息")
  private Set<DealerContactPersonMdmVo> dealerContactPersons;

  /**
   * 对接人信息
   */
  @ApiModelProperty("对接人信息")
  private Set<DealerCommunicationMdmVo> dealerCommunications;

  /**
   * 企业组织
   */
  @ApiModelProperty("企业组织")
  private List<CustomerRelateOrgVo> orgList;

}
