package com.biz.crm.cps.external.mdm.sdk.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: mdm物料组vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Api(tags = "物料组Vo")
public class MaterialGroupMdmVo {

  @ApiModelProperty("id")
  private String id;
  /**
   * 物料组编码
   */
  @ApiModelProperty("物料组编码")
  private String materialGroupCode;
  /**
   * 物料组名称
   */
  @ApiModelProperty("物料组名称")
  private String materialGroupName;

  /**
   * 物料组描述
   */
  @ApiModelProperty("物料组描述")
  private String description;

  /**
   * 物料数量
   */
  @ApiModelProperty("物料数量")
  private BigDecimal materialNum;

  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /**
   *物料信息
   */
  @ApiModelProperty("物料信息")
  private List<MaterialMdmVo> materialMdmVos;
}
