package com.biz.crm.cps.external.mdm.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: mdm物料vo
 * @date 2021/8/9 下午7:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MaterialMdmVo extends TenantOpVo {

  private static final long serialVersionUID = 3591023009961179762L;

  @ApiModelProperty("id")
  private String id;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 产品名称
   */
  @ApiModelProperty("产品名称")
  private String materialName;


  /**
   * ai编码
   */
  @ApiModelProperty("ai编码")
  private String aiCode;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private String baseUnit;

  /**
   * 物料类型
   *
   *
   * <pre>
   * "big":"大"
   * "small", "小"
   * "bzsp": "标准商品"
   * "cx":"促销品"
   * "finished_product":"产成品"
   * "marketing_materials":"营销物料"
   * </pre>
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /**
   * 销售公司
   */
  @ApiModelProperty("销售公司")
  private String saleCompany;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String specification;

  /**
   * 单位换算系数
   */
  @ApiModelProperty("单位换算系数")
  private String unitConversion;

  /**
   * 成本价格
   */
  @ApiModelProperty("成本价格")
  private String costPrice;

  /**
   * 毛重
   */
  @ApiModelProperty("毛重")
  private String grossWeight;

  /**
   * 净重
   */
  @ApiModelProperty("净重")
  private String netWeight;

  /**
   * 容量
   */
  @ApiModelProperty("容量")
  private String capacity;
  /**
   * 标准单位
   */
  @ApiModelProperty("标准单位")
  private String standardUnit;
  /**
   * 盒码单位转算系数
   */
  @ApiModelProperty("盒码单位转算系数")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转算系数
   */
  @ApiModelProperty("箱码单位转算系数")
  private BigDecimal caseUnitConversion;

  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 层级集合 （指本商品所属层级 所有父节点的信息 包括自己）
   */
  @ApiModelProperty("层级集合")
  private List<ProductLevelMdmVo> productLevels;

  /**
   * 物料图片
   */
  @ApiModelProperty("物料图片")
  private List<MaterialMediaMdmVo> materialMedias;
}
