package com.biz.crm.cps.external.mdm.sdk.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: mdm物料图片vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Api(tags = "物料图片Vo")
public class MaterialMediaMdmVo {

  @ApiModelProperty("id")
  private String id;
  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
  /**
   * 物料id
   */
  @ApiModelProperty("物料id")
  private String materialId;
  /**
   * 图片地址
   */
  @ApiModelProperty("图片地址")
  private String urlAddress;
  /**
   * 排序位置
   */
  @ApiModelProperty("排序位置")
  private Integer rangeNum;


  /**
   * 图片类型(central 主图片 display 陈列图片 detail 详情图片)
   */
  @ApiModelProperty("图片类型")
  private String businessType;

  /**
   * 文件名称
   */
  @ApiModelProperty("文件名称")
  private String fileName;

  /**
   * 源文件名称
   */
  @ApiModelProperty("源文件名称")
  private String originalFileName;

  /**
   * 地址
   */
  @ApiModelProperty("地址")
  private String relativeLocal;
  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;
}
