package com.biz.crm.cps.external.mdm.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: mdm商品层级vo
 * @date 2021/8/9 下午7:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ProductLevelMdmVo extends TenantOpVo {
  private static final long serialVersionUID = 1983319130450618112L;

  @ApiModelProperty("id")
  private String id;

  /**
   * 规则code查询用
   */
  @ApiModelProperty("规则code查询用")
  private String ruleCode;

  /**
   * 层级等级查询用
   */
  @ApiModelProperty("层级等级查询用")
  private Integer levelNum;
  /**
   * 上级编码
   */
  @ApiModelProperty("上级编码")
  private String parentCode;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  /**
   * 产品层级类型
   * <pre>
   *   "brand":"品牌"
   *   "series":"系列"
   *   "max":"大类"
   *   "min":"细类"
   * </pre>
   */
  @ApiModelProperty("产品层级类型")
  private String productLevelType;

  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /**
   * 父节点
   */
  @ApiModelProperty("父节点")
  private ProductLevelMdmVo parent;

}
